<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __('common.Document') }}</title>
    <link rel="stylesheet" href="{{ asset('Modules/Store/Resources/assets/css/sale_print.css') }}">
</head>

<body>
<div class="invoice_wrapper">
    <div class="invoice_print mb_30">
        <div class="container">
            <div class="invoice_part_iner">
                <table class="table border_bottom mb_30">
                    <thead>
                    <tr>
                        <td>
                            <div class="logo_div">
                                <img src="{{ getCourseImage(Settings('logo')) }}" alt="">
                            </div>
                        </td>
                        <td class="virtical_middle text_right invoice_info">
                            <h4 class="text_uppercase">{{ Settings('site_title') }}</h4>
                            <h4>{{ Settings('phone') }}</h4>
                            <h4>{{ Settings('email') }}</h4>
                            <h4>{{ $order->order_number }}</h4>
                        </td>
                    </tr>
                    </thead>
                </table>
                <table class="table">
                    <tbody>
                    <tr>
                        <td>
                            <table class="mb_20">
                                <tbody>
                                <tr>
                                    <td>
                                        <h5 class="font_18 mb-0">{{ __('product.Billing Info') }}</h5>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Name') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->first_name }} {{ @$order->bill->last_name }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Phone') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->phone }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Address') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->address1 }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Address') }} 2</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->address2 }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Country') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->countryDetails->name }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.City') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->cityDetails->name }}
                                        </p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                        <td>
                            <table class="mb_20">
                                <tbody>
                                <tr>
                                    <td>
                                        <h5 class="font_18 mb-0">{{ __('product.Company Info') }}</h5>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                        <span>
                                                            <span>{{ __('common.Name') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ Settings('site_title') }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                        <span>
                                                            <span>{{ __('common.Email') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ Settings('email') }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                        <span>
                                                            <span>{{ __('common.Phone') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ Settings('phone') }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid">
                                                        <span>
                                                            <span>{{ __('store.order') }}
                                                                {{ __('common.date') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ showDate(@$order->created_at) }}
                                        </p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <table>
                                <tbody>
                                <tr>
                                    <td>
                                        <h5 class="font_18 mb-0">{{ __('product.Shipping Info') }}</h5>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Name') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->first_name }} {{ @$order->bill->last_name }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Phone') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->phone }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Address') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->address1 }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Address') }} 2</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->address2 }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.Country') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->countryDetails->name }}
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="line_grid_2">
                                                        <span>
                                                            <span>{{ __('common.City') }}</span>
                                                            <span>:</span>
                                                        </span>
                                            {{ @$order->bill->cityDetails->name }}
                                        </p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                        <td>
                            <table>
                                <tbody>
                                <tr>
                                    <td>
                                        <table class="mb_20">
                                            <tbody>
                                            <tr>
                                                <td>
                                                    <h5 class="font_18 mb-0">
                                                        {{ __('product.Order Info') }}</h5>
                                                </td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('product.Is Paid') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        {{ $order->is_paid == 1 ? __('common.Yes') : __('common.No') }}
                                                    </p>
                                                </td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('product.Subtotal') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        @php
                                                            $p_total = 0;
                                                            $p_qty = 0;
                                                            $shipping_cost = 0;

                                                            foreach ($packages as $key => $ordered_package) {
                                                                $total = 0;
                                                                $qty = 0;

                                                                $all_product = Modules\Store\Entities\OrderPackageDetail::where(['order_id' => $ordered_package->order_id, 'seller_id' => $ordered_package->seller_id])->get();
                                                                foreach ($all_product as $key => $item) {
                                                                    $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;

                                                                    if ($item->is_store == 1) {
                                                                        $price1 = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
                                                                        $price = $price1 * $item->number_of_product;
                                                                    } else {
                                                                        $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
                                                                        $price1 = $price;
                                                                    }

                                                                    $total = $total + $price;
                                                                    $shipping_cost = $shipping_cost + $item->shipping_cost;
                                                                    $qty = $qty + $item->tax_amount;
                                                                }
                                                                $p_total = $p_total + $total;
                                                                if (isModuleActive('Tax')) {
                                                                    $p_qty = $p_qty + $qty;
                                                                }
                                                            }

                                                        @endphp
                                                        {{ getPriceFormat($p_total) }}
                                                    </p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('common.Discount') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        @if ($order->discount == 0)
                                                            0
                                                        @else
                                                            {{ getPriceFormat($order->discount) }}
                                                        @endif
                                                    </p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('product.Shipping Charge') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        {{ getPriceFormat($shipping_cost) }}
                                                    </p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('product.Tax') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        {{ getPriceFormat($p_qty) }}
                                                    </p>
                                                </td>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <p class="line_grid">
                                                                        <span>
                                                                            <span>{{ __('product.Grand Total') }}</span>
                                                                            <span>:</span>
                                                                        </span>
                                                        {{ getPriceFormat($p_qty + $p_total + $order->shipping_cost) }}

                                                    </p>
                                                </td>
                                            </tr>

                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <h3 class="center title_text">{{ __('product.Ordered Products') }}</h3>

    @foreach ($packages as $key => $order)
        <table class="table">
            <tbody>
            <tr>
                <td>
                    <p class="line_grid_2">
                                <span>
                                    <span>{{ __('product.package') }}</span>
                                    <span>:</span>
                                </span>
                        {{ $order->package_code }}
                    </p>
                </td>
                <td>
                    <p class="line_grid_auto grid_end">
                                <span>
                                    <span>{{ __('product.shipping_method') }}</span>
                                    <span>:</span>
                                </span>
                        {{ $order->shipping->method_name }}
                    </p>
                </td>
            </tr>

            </tbody>
        </table>




        <table class="table border_table mb_20">

            @php
                $total = 0;
                $language_code = auth()->user()->language_code ?? 'en';
                $sl = 1;
                $all_product = Modules\Store\Entities\OrderPackageDetail::where(['order_id' => $order->order_id, 'seller_id' => $order->seller_id])->get();
            @endphp

            @foreach ($all_product as $key => $item)
                <tr>
                    <td class="black_color">
                            <span class="ps-3">
                                {{ $sl++ }}
                            </span>
                    </td>
                    <td colspan="2" style="text-align: left">
                        <h5 class="black_color"> {{ @$item->course->getTranslation('title', $language_code) }}</h5>
                    </td>

                    <td class="black_color">
                        {{ $item->is_store ? ($item->course->product->type == 2 ? __('product.Physical') : __('product.Virtual')) : __('product.Virtual') }}
                    </td>
                    <td class="black_color">
                        {{ $item->qty }}
                    </td>

                    @php
                        $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;

                        if ($item->is_store == 1) {
                            $price1 = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
                            $price = $price1 * $item->number_of_product;
                        } else {
                            $price = $item->course->discount_price != 0 ? $item->course->discount_price : $item->course->price;
                            $price1 = $price;
                        }

                        $total = $total + $price;
                    @endphp
                    <td style="text-align: left" class="black_color">{{ getPriceFormat($price1) }}</td>

                    <td style="text-align: left" class="black_color">{{ getPriceFormat($price) }}</td>
                </tr>
            @endforeach
        </table>

        <hr>
    @endforeach
</div>


<script src="{{ asset('public/js/common.js') }}"></script>
<script type="text/javascript">
    (function ($) {
        "use strict";
        $(document).ready(function () {
            window.print();
        });
    })(jQuery);
</script>
</body>

</html>
