<?php

namespace Modules\Store\Repositories;

use App\Traits\ImageStore;
use Illuminate\Support\Facades\DB;
use App\Repositories\CountryRepository;
use Modules\Store\Entities\PickupLocation;
use Modules\Store\Entities\ProductCarrier;
use Modules\Store\Entities\SellerWiseCarrierConfig;


class PickupLocationRepository
{
    use ImageStore;

    protected $countryRepository;

    public function __construct(CountryRepository $countryRepository)
    {
        $this->countryRepository = $countryRepository;
    }

    public function all()
    {
        $user_id = getParentSellerId();
        $pickupLocations = PickupLocation::with(['country', 'state', 'city'])->where('created_by', $user_id)->get();
        if ($pickupLocations->count() > 0) {
            return $pickupLocations;
        }
        return $pickupLocations;
    }

    public function getActiveAll()
    {
        $user_id = getParentSellerId();
        return PickupLocation::with(['country', 'state', 'city'])->where('created_by', $user_id)->where('status', 1)->get();
    }

    public function create(array $data)
    {
        $user_id = getParentSellerId();
        $location = PickupLocation::create([
            'pickup_location' => $data['pickup_location'],
            'name' => $data['name'],
            'email' => $data['email'],
            'phone' => $data['phone'],
            'address' => $data['address'],
            'address_2' => $data['address_2'],
            'city_id' => $data['city_id'] ?? null,
            'state_id' => $data['state_id'] ?? null,
            'country_id' => $data['country_id'] ?? null,
            'pin_code' => $data['pin_code'],
            'created_by' => $user_id,
        ]);

        $flag = false;
        $carrier = ProductCarrier::where('slug', 'Shiprocket')->first();
        if ($carrier) {
            $row = SellerWiseCarrierConfig::where('seller_id', $user_id)->where('carrier_id', $carrier->id)->where('carrier_status', 1)->first();
            if ($row) {
                $flag = true;
            }
        }

        return $location;
    }

    public function getStateByCountry($id)
    {
        return $this->countryRepository->getStateByCountry($id);
    }

    public function getCityByState($id)
    {
        return $this->countryRepository->getCityByState($id);
    }

    public function find($id)
    {
        return PickupLocation::with(['country', 'state', 'city'])->findOrFail($id);
    }

    public function update(array $data, $id)
    {
        $user_id = getParentSellerId();
        return PickupLocation::where('id', $id)->where('created_by', $user_id)->update([
            'pickup_location' => $data['pickup_location'],
            'name' => $data['name'],
            'email' => $data['email'],
            'phone' => $data['phone'],
            'address' => $data['address'],
            'address_2' => $data['address_2'],
            'city_id' => isset($data['city_id']) ? $data['city_id'] : null,
            'state_id' => isset($data['state_id']) ? $data['state_id'] : null,
            'country_id' => isset($data['country_id']) ? $data['country_id'] : null,
            'pin_code' => $data['pin_code'],
        ]);
    }

    public function delete($id)
    {
        $user_id = getParentSellerId();
        $location = PickupLocation::where('id', $id)->where('created_by', $user_id)->first();
        if ($location && $location->is_default == 0) {
            $location->delete();
            return true;
        }
        return false;
    }

    public function status($data)
    {
        return PickupLocation::findOrFail($data['id'])->update(['status' => $data['status']]);
    }

    public function setPickupLocation($id)
    {
        $user_id = getParentSellerId();
        DB::table('pickup_locations')->where('created_by', $user_id)->update(array('is_set' => 0));
        PickupLocation::where('id', $id)->update(['is_set' => 1]);
        return true;
    }

    public function setDefault($data)
    {
        $user_id = getParentSellerId();
        DB::table('pickup_locations')->where('created_by', $user_id)->update(array('is_default' => 0));
        return PickupLocation::findOrFail($data['id'])->update(['is_default' => $data['set_default']]);
    }
}
