<?php

namespace Modules\Store\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Course;
use Modules\Payment\Entities\Checkout;

class OrderPackageDetail extends Model
{
    protected $fillable = [];

    protected $guarded = ['id'];
    protected $appends = ['deliveryStateName', 'totalGST', 'processes'];

    public function pickupPoint()
    {
        return $this->belongsTo(PickupLocation::class, 'pickup_point_id')->withDefault();
    }

    public function cancel_reason()
    {
        return $this->belongsTo(CancelReason::class, 'cancel_reason_id', 'id');
    }

    public function products()
    {
        return $this->hasMany(OrderProductDetail::class, 'package_id', 'id');
    }

    public function packageProductDetail()
    {
        return $this->hasOne(OrderProductDetail::class, 'package_id', 'id');
    }

    public function product_details()
    {
        return $this->hasMany(OrderProductDetail::class, 'seller_id', 'seller_id');
    }

    public function shipping()
    {
        return $this->belongsTo(ShippingMethod::class, 'shipping_method', 'id')->withDefault();
    }

    public function carrier()
    {
        return $this->belongsTo(ProductCarrier::class, 'carrier_id', 'id')->withDefault();
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id', 'id')->withDefault();
    }

    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id', 'id');
    }

    public function delivery_process()
    {
        return $this->belongsTo(DeliveryProcess::class, 'delivery_status', 'id');
    }

    public function refundPackage()
    {
        return $this->hasOne(RefundRequestDetail::class, 'order_package_id', 'id');
    }

    public function subTotal()
    {
        $sub_total = 0;
        foreach ($this->products as $product) {
            $sub_total += $product->qty * $product->price;
        }
        return $sub_total;
    }

    public function getDeliveryStateNameAttribute()
    {
        if ($this->order->is_cancelled==1 || $this->order->is_confirmed==2) {
            return 'Canceled';
        }
        if ($this->delivery_status <= 1) {
            return "Pending";
        }elseif ($this->delivery_status == 2) {
            return "Processing";
        } elseif ($this->delivery_status == 3) {
            return "Shipped";
        } elseif ($this->delivery_status == 4) {
            return "Received";
        } elseif ($this->delivery_status >= 5) {
            return "Delivered";
        }

    }

    public function getProcessesAttribute()
    {
        return DeliveryProcess::all();
    }

    public function getTotalGSTAttribute()
    {
        return 0;
    }

    public function order()
    {
        return $this->belongsTo(Checkout::class, 'order_id', 'id');
    }


}
