@extends('backend.master')


@php
    $table_name='noticeboards';
@endphp
@section('table')
    {{$table_name}}
@endsection
@section('mainContent')

    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{$group==2?trans('courses.Course'):trans('noticeboard.General')}} {{__('noticeboard.Noticeboard')}}</h3>

                                <ul class="d-flex">
                                    @if (permissionCheck($group==2?'noticeboard.course.store':'noticeboard.store'))
                                        <li>
                                            <a class="primary-btn radius_30px fix-gr-bg" data-bs-toggle="modal"
                                               id=""
                                               data-bs-target="#add_noticeboard" href="#"><i
                                                    class="ti-plus"></i>{{__('common.Add')}}  @if($group==2)
                                                    {{__('courses.Course')}}
                                                @else
                                                    {{__('noticeboard.General')}}
                                                @endif  {{__('noticeboard.Noticeboard')}}
                                            </a>
                                        </li>
                                    @endif
                                </ul>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12 ">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{__('common.SL')}}</th>
                                            <th scope="col">{{__('common.Title')}}</th>
                                            <th scope="col">
                                                @if($group==2)
                                                    {{__('courses.Course')}}
                                                @else
                                                    {{__('common.Role')}}
                                                @endif
                                            </th>
                                            <th scope="col">{{__('noticeboard.Sender')}}</th>
                                            <th scope="col">{{__('noticeboard.Type')}}</th>
                                            <th scope="col">{{__('noticeboard.Send At')}}</th>
                                            <th scope="col">{{__('common.Status')}}</th>
                                            <th scope="col">{{__('common.Action')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($notices as $key=>$notice)
                                            <tr>
                                                <td>{{++$key}}</td>
                                                <td>{{$notice->title}}</td>
                                                <td>
                                                    @foreach($notice->assign as $assign)
                                                        @if($group==2)
                                                            @php
                                                                $course =$assign->course;
                                                            @endphp
                                                            <a href="{{courseDetailsUrl($course->id, $course->type, $course->slug)}}">{{$course->title}}</a>
                                                        @else
                                                            @php
                                                                $role =$assign->role;
                                                            @endphp
                                                            <a href="#">{{$role->name}}</a>
                                                        @endif
                                                        <br>
                                                    @endforeach
                                                </td>
                                                <td>{{$notice->user->name}}</td>
                                                <td>{{$notice->noticeType->title}}</td>
                                                <td>{{$notice->created_at->diffForHumans()}}</td>
                                                <td class="nowrap">
                                                    <x-backend.status :id="$notice->id" :status="$notice->status"
                                                                      :route="'noticeboard.course.changeStatus'"></x-backend.status>

                                                </td>
                                                <td>
                                                    @include('noticeboard::notice._action',compact('notice'))
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    @include('noticeboard::notice._add_modal')
    <div class="modal fade admin-query" id="editNotice">
    </div>
    <input type="hidden" value="{{route('noticeboard.findById')}}" id="findByIdName">

    @include('noticeboard::notice._delete_modal')
@endsection
@push('scripts')

    <script src="{{asset('Modules/Noticeboard/Resources/assets/js/script.js')}}"></script>

    <script type="application/javascript">
        (function ($) {
            "use strict";


        dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5]);

         $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
