@extends(theme('layouts.master'))
@section('title')
    {{ Settings('site_title') ? Settings('site_title') : 'Infix LMS' }} | {{ $course->title }}
@endsection
@section('og_image')
    {{ getCourseImage($course->image) }}
@endsection
@section('meta_title')
    {{ $course->meta_keywords }}
@endsection
@section('meta_description')
    {{ $course->meta_description }}
@endsection
@section('css')
    <style>
        .course__details .video_screen {
            background-image: url('{{ getCourseImage(@$course->image) }}');
        }

        iframe {
            position: relative !important;
        }

        .contact_info {
            padding-top: 90px !important;
        }
    </style>
@endsection


@section('mainContent')
    <x-breadcrumb :banner="$frontendContent->course_page_banner" :title="trans('frontend.Course Details')"
                  :subTitle="$course->title"/>

    <div class="contact_section ">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-10">
                    <div class="contact_address">
                        <div class="row justify-content-center">
                            <div class="col-xl-12">
                                <div class="row justify-content-between">

                                    <div class="col-lg-5 mt-5">
                                        <h2 class="mt-20 text-start font-weight-bold "
                                            style="font-size: 48px !important;">
                                            {{ @$title }}
                                        </h2>
                                        <div class="couse_wizged mt-4">
                                            <a href="{{courseDetailsUrl(@$course->id,@$course->type,@$course->slug)}}">
                                                <div class="thumb">

                                                    <div class="thumb_inner lazy"
                                                         data-src="{{ getCourseImage($course->thumbnail) }}">
                                                    </div>
                                                    <x-price-tag :price="$course->price"
                                                                 :discount="$course->discount_price"/>
                                                </div>
                                            </a>
                                            <div class="course_content">
                                                <a href="{{courseDetailsUrl(@$course->id,@$course->type,@$course->slug)}}">

                                                    <h4 class="noBrake" title=" {{$course->title}}">
                                                        {{$course->title}}
                                                    </h4>
                                                </a>
                                                <div class="rating_cart">
                                                    <div class="rateing">
                                                        <span>{{$course->totalReview}}/5</span>

                                                        <i class="fas fa-star"></i>
                                                    </div>
                                                    @if(!onlySubscription())
                                                        @auth()
                                                            @if(!$course->isLoginUserEnrolled && !$course->isLoginUserCart)
                                                                <a href="#" class="cart_store"
                                                                   data-id="{{$course->id}}">
                                                                    <i class="fas fa-shopping-cart"></i>
                                                                </a>
                                                            @endif
                                                        @endauth
                                                        @guest()
                                                            @if(!$course->isGuestUserCart)
                                                                <a href="#" class="cart_store"
                                                                   data-id="{{$course->id}}">
                                                                    <i class="fas fa-shopping-cart"></i>
                                                                </a>
                                                            @endif
                                                        @endguest
                                                    @endif
                                                </div>
                                                <div class="course_less_students">
                                                    <a> <i class="ti-agenda"></i> {{count($course->lessons)}}
                                                        {{__('frontend.Lessons')}}</a>
                                                    @if(!Settings('hide_total_enrollment_count') == 1)
                                                        <a>
                                                            <i class="ti-user"></i> {{$course->total_enrolled}} {{__('frontend.Students')}}
                                                        </a>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>


                                    </div>
                                    <div class="col-lg-6  mt-5">
                                        <div class="contact_form_box mb_30">

                                            <div data-type="component-nonExisting" data-preview="" data-table=""
                                                 data-select="" data-order="" data-limit="" data-view="_contact_form"
                                                 data-model="" data-with="">


                                                    <div>
                                                        <form class="form-area contact-form"
                                                              action="{{ route('gift.store') }}" method="post">
                                                            @csrf
                                                            <div class="row">
                                                                <div class="col-lg-12">
                                                                    <label
                                                                        class="primary_label">{{__('frontend.Name')}}  <span class="">*</span>
                                                                        </label>
                                                                    <input type="hidden" name="course_id"
                                                                           value="{{$course->id}}">
                                                                    <input name="name"
                                                                           placeholder="{{__('frontend.Enter Name')}}"

                                                                           class="primary_input mb-4 " type="text"
                                                                           required
                                                                           value="{{old('name')}}">
                                                                    <span class="text-danger"
                                                                          >{{$errors->first('name')}}</span>

                                                                    <label
                                                                        class="primary_label">{{__('frontend.Email Address')}}
                                                                        <span class="">*</span></label>
                                                                    <input name="email" required
                                                                           placeholder="{{__('frontend.Type e-mail address')}}"
                                                                           pattern="[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{1,63}$"
                                                                           onfocus="this.placeholder = ''"
                                                                           onblur="this.placeholder = '{{__('frontend.Type e-mail address')}}'"
                                                                           class="primary_input mb-4 "
                                                                           type="email" value="{{old('email')}}">
                                                                    <span class="text-danger"
                                                                          >{{$errors->first('email')}}</span>
                                                                    <label
                                                                        class="primary_label">{{_trans('frontend.When do you want to send this gift')}}
                                                                        <span class="">*</span></label>
                                                                    <input name="date_time" required
                                                                           class="primary_input mb-4 "
                                                                           type="datetime-local"
                                                                           value="{{old('subject')}}">
                                                                    <span class="text-danger"
                                                                          >{{$errors->first('subject')}}</span>
                                                                </div>
                                                                <div class="col-lg-12">
                                                                    <label
                                                                        class="primary_label">{{__('frontend.Message')}}
                                                                        (optional)</label>
                                                                    <textarea class="primary_textarea mb-4"
                                                                              name="message"
                                                                              placeholder="{{__('frontend.Write your message')}}"
                                                                              onfocus="this.placeholder = ''"
                                                                              onblur="this.placeholder = '{{__('frontend.Write your message')}}'"
                                                                    >{{old('message')}}</textarea>
                                                                    <span class="text-danger"
                                                                          >{{$errors->first('message')}}</span>
                                                                </div>

                                                                <div class="col-lg-12 text-start">
                                                                    <div class="alert-msg"></div>


                                                                    <button type="submit"
                                                                            class="theme_btn small_btn submit-btn w-100 text-center">
                                                                        {{_trans('frontend.Proceed to Checkout')}}
                                                                    </button>

                                                                </div>
                                                            </div>
                                                        </form>
                                                    </div>


                                            </div>

                                        </div>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')

@endsection
