<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBundleCoursePlansTable extends Migration
{
    public function up()
    {
        Schema::create('bundle_course_plans', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->decimal('price', 13, 2)->default(0);
            $table->text('about')->nullable();
            $table->integer('days')->nullable();
            $table->boolean('status')->default(1);
            $table->integer('order')->default(0);
            $table->string('button_text')->nullable();
            $table->integer('student')->default(0);
            $table->integer('user_id')->default(0);
            $table->integer('reveune')->default(0);
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('bundle_course_plans');
    }
}
