<?php


Route::group(['prefix' => 'survey', 'middleware' => ['student'], 'as' => 'survey.'], function () {

    Route::get('student-survey', 'StudentSurveyController@studentSurvey')->name('student_survey');
    Route::get('student-survey-participate/{id}', 'StudentSurveyController@show')->name('student_survey_participate');
    Route::post('student-survey-participate/{id}', 'StudentSurveyController@store')->name('student_survey_participate_store');

});
Route::group(['prefix' => 'survey', 'middleware' => ['auth', 'admin'], 'as' => 'survey.'], function () {

    Route::get('/list', 'SurveyController@index')->name('survey_list')->middleware('RoutePermissionCheck:survey.survey_list');
    Route::post('/add', 'SurveyController@store')->name('survey_store')->middleware('RoutePermissionCheck:survey.survey_store');
    Route::post('/update', 'SurveyController@update')->name('survey_update')->middleware('RoutePermissionCheck:survey.survey_update');
    Route::get('/delete/{id}', 'SurveyController@destroy')->name('survey_delete')->middleware('RoutePermissionCheck:survey.survey_delete');

    Route::get('/add', 'SurveyController@create')->name('survey_add')->middleware('RoutePermissionCheck:survey.survey_store');
    Route::get('/edit/{id}', 'SurveyController@edit')->name('survey_edit')->middleware('RoutePermissionCheck:survey.survey_update');
    Route::get('/studStaffByRole', 'SurveyController@studStaffByRole')->name('studStaffByRole');

    Route::get('/set-question/{id}', 'SurveyController@setQuestion')->middleware('RoutePermissionCheck:survey.question_assign');
    Route::post('set-question/{id}', 'SurveyQuestionController@store')->name('question_assign')->middleware('RoutePermissionCheck:survey.question_assign');

    //Question Answer Set
    Route::get('answer-set', 'QuestionSetController@index')->name('set_list')->middleware('RoutePermissionCheck:survey.set_list');
    Route::post('answer-set', 'QuestionSetController@store')->name('set_store')->middleware('RoutePermissionCheck:survey.set_store');
    Route::get('answer-set/{id}', 'QuestionSetController@edit')->name('set_edit')->middleware('RoutePermissionCheck:survey.set_update');
    Route::post('answer-set-update', 'QuestionSetController@update')->name('set_update')->middleware('RoutePermissionCheck:survey.set_update');
    Route::get('answer-set/delete/{id}', 'QuestionSetController@destroy')->name('set_delete')->middleware('RoutePermissionCheck:survey.set_delete');

    Route::get('set-attribute/{set_id}', 'QuestionSetAttributeController@getSetAttributeList')->name('set_attribute')->middleware('RoutePermissionCheck:survey.set_attribute');
    Route::post('set-attribute/{set_id}', 'QuestionSetAttributeController@store')->name('set_attribute_store')->middleware('RoutePermissionCheck:survey.set_attribute_store');
    Route::get('attribute-edit/{set_id}/{attribute_id}', 'QuestionSetAttributeController@edit')->name('attribute_edit')->middleware('RoutePermissionCheck:survey.set_attribute_update');
    Route::post('attribute-update', 'QuestionSetAttributeController@update')->name('set_attribute_update')->middleware('RoutePermissionCheck:survey.set_attribute_update');
    Route::get('attribute-delete/{attribute_id}', 'QuestionSetAttributeController@destroy')->name('set_attribute_delete')->middleware('RoutePermissionCheck:survey.set_attribute_delete');

    Route::get('/ajaxAnswerSetFromAnswerType', 'QuestionSetController@ajaxAnswerSetFromAnswerType')->name('ajaxAnswerSetFromAnswerType');


    Route::get('my-survey', 'UserSurveyController@index')->name('my_survey')->middleware('RoutePermissionCheck:survey.my_survey');
    Route::get('survey-participate/{id}', 'UserSurveyController@show')->name('survey_participate')->middleware('RoutePermissionCheck:survey.survey_participate_store');
    Route::post('survey-participate/{id}', 'UserSurveyController@store')->name('survey_participate_store')->middleware('RoutePermissionCheck:survey.survey_participate_store');

    Route::get('survey-participants/{survey_id}', 'UserSurveyController@surveyParticipants')->name('survey_participants');
    Route::get('survey-participants-view/{survey_id}/{user_id}', 'UserSurveyController@surveyParticipantsView')->name('survey_participants_view');

    Route::get('survey-user-wise/{survey_id}', 'UserSurveyController@userBasedReport')->name('user_based_report');
    Route::post('survey-user-wise/{survey_id}', 'UserSurveyController@userBasedReportSearch')->name('user_based_report_search');

    Route::get('survey-question-wise/{survey_id}', 'UserSurveyController@questionBasedReport')->name('question_based_report');
    Route::post('survey-question-wise/{survey_id}', 'UserSurveyController@questionBasedReportSearch')->name('question_based_report_search');

    Route::get('survey-question-graph/{survey_id}', 'SurveyReportController@questionBasedGraph')->name('question_based_graph');
    Route::post('survey-question-graph/{survey_id}', 'SurveyReportController@questionBasedGraphSearch')->name('question_based_graph_search');

    Route::get('course-survey-report/{course_id}', 'SurveyReportController@courseSurvey')->name('courseSurvey');
    Route::get('group-survey-report/{group_id}', 'SurveyReportController@groupSurvey')->name('groupSurvey');


    Route::get('setting', 'SurveyController@setting')->name('setting')->middleware('RoutePermissionCheck:survey.setting');
    Route::post('setting', 'SurveyController@settingSubmit')->middleware('RoutePermissionCheck:survey.setting');

    Route::get('groups', 'SurveyGroupController@index')->name('group.index')->middleware('RoutePermissionCheck:survey.group.index');
    Route::post('groups/store', 'SurveyGroupController@store')->name('group.store')->middleware('RoutePermissionCheck:survey.group.store');
    Route::post('groups/update', 'SurveyGroupController@update')->name('group.update')->middleware('RoutePermissionCheck:survey.group.update');
    Route::get('groups/edit/{id}', 'SurveyGroupController@edit')->name('group.edit')->middleware('RoutePermissionCheck:course.category.update');
    Route::get('groups/delete/{id}', 'SurveyGroupController@destroy')->name('group.delete')->middleware('RoutePermissionCheck:survey.group.delete');


    Route::get('survey-bank', 'SurveyQuestionBankController@form')->name('survey-bank')->middleware('RoutePermissionCheck:survey.survey-bank');
    Route::get('survey-bank-list', 'SurveyQuestionBankController@index')->name('survey-bank-list')->middleware('RoutePermissionCheck:survey.survey-bank-list');
    Route::get('survey-bank-list-date', 'SurveyQuestionBankController@data')->name('survey-bank-list-data')->middleware('RoutePermissionCheck:survey.survey-bank-list');
    Route::post('survey-bank', 'SurveyQuestionBankController@store')->name('survey-bank.store')->middleware('RoutePermissionCheck:survey.survey-bank.store');
    Route::get('survey-bank/{id}', 'SurveyQuestionBankController@show')->name('survey-bank-edit')->middleware('RoutePermissionCheck:survey.survey-bank-update');
    Route::put('survey-bank/{id}', 'SurveyQuestionBankController@update')->name('survey-bank-update')->middleware('RoutePermissionCheck:survey.survey-bank-update');
    Route::post('survey-bank-delete', 'SurveyQuestionBankController@destroy')->name('survey-bank-delete')->middleware('RoutePermissionCheck:survey.survey-bank-delete');

    Route::get('survey-bank-bulk', 'SurveyQuestionBankController@questionBulkImport')->name('survey-bank-bulk')->middleware('RoutePermissionCheck:survey.survey-bank-bulk');
    Route::post('survey-bank-bulk', 'SurveyQuestionBankController@questionBulkImportSubmit')->name('survey-bank-bulk-submit')->middleware('RoutePermissionCheck:survey.survey-bank-bulk');

    Route::get('download-sample', 'SurveyQuestionBankController@downloadSample')->name('download-sample');

    Route::post('online-exam-question-assign-by-ajax', ['as' => 'survey_question_assign_by_ajax', 'uses' => 'SurveyController@surveyQuestionAssignByAjax']);

});
