@extends('backend.master')
@section('mainContent')
    {!! generateBreadcrumb() !!}

    <div class="row">
        <div class="col-lg-12">
            <div class="white-box mb-30">
                <form method="GET" action="" class="form-horizontal" id="search_group">
                    <div class="row">

                        <div class="col-lg-4 mt-30-md md_mb_20">
                            <label class="primary_input_label" for="category_id">{{__('common.Type')}} <span
                                    class="required_mark">*</span></label>
                            <select {{ $errors->has('question_type') ? ' autofocus' : '' }}
                                    class="primary_select{{ $errors->has('question_type') ? ' is-invalid' : '' }}"
                                    name="question_type" id="question-type">
                                <option data-display="{{__('survey.Survey Type')}} "
                                        value="">{{__('survey.Survey Type')}}
                                </option>

                                <option
                                    value="checkbox" {{request('question_type')=='checkbox'?'selected':''}}> {{__('survey.Checkbox')}}</option>
                                <option
                                    value="dropdown" {{request('question_type')=='dropdown'?'selected':''}}> {{__('survey.Dropdown')}}</option>
                                <option
                                    value="radio" {{request('question_type')=='radio'?'selected':''}}> {{__('survey.Radio')}}</option>
                                <option
                                    value="textarea" {{request('question_type')=='textarea'?'selected':''}} > {{__('survey.TextArea')}}</option>
                                <option
                                    value="linear_scale" {{request('question_type')=='linear_scale'?'selected':''}}> {{__('survey.Linear Scale')}}</option>

                            </select>

                        </div>

                        <div class="col-lg-4 mt-30-md md_mb_20">
                            <label class="primary_input_label" for="category_id">{{__('common.Category')}}</label>
                            <select class="primary_select "
                                    id="category" name="category">
                                <option data-display=" {{__('common.Select')}}" value=""> {{__('common.Category')}}
                                </option>
                                @foreach($categories as $category)
                                    @if($category->parent_id==0)
                                        @include('backend.categories._single_select_option',['category'=>$category,'level'=>1])
                                    @endif
                                @endforeach
                            </select>

                        </div>


                        <div class="col-lg-12  mt-3">
                            <label class="primary_input_label" for=""></label>
                            <button type="submit" class="primary-btn    fix-gr-bg">
                                <span class="ti-search pe-2"></span>
                                {{__('quiz.Search')}}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">

            <div class="white-box">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="main-title d-flex justify-content-between">
                            <div>
                                <h3 class="mb-20" id="page_title">{{__('quiz.Question Bank List')}}</h3>
                            </div>
                            <div class="ps-3">
                                <a href="{{route('survey.survey-bank')}}" class="primary-btn mb-3   fix-gr-bg">
                                    <span class="ti-plus pe-2"></span>
                                    {{__('common.Add')}}
                                </a>
                            </div>

                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table">

                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th>{{__('common.SL')}}</th>
                                            <th>{{__('quiz.Group')}}</th>
                                            <th>{{__('quiz.Category')}}</th>
                                            <th>{{__('survey.Survey Question')}}</th>
                                            <th>{{__('common.Type')}}</th>
                                            <th>{{__('quiz.Image')}}</th>
                                            <th>{{__('common.Action')}}</th>
                                        </tr>
                                        </thead>


                                        <tbody>


                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <div class="modal fade admin-query" id="deleteBank">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">{{__('common.Delete')}} </h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                            class="ti-close "></i></button>
                </div>

                <div class="modal-body">
                    <form action="{{route('survey.survey-bank-delete')}}" method="post">
                        @csrf

                        <div class="text-center">

                            <h4>{{__('common.Are you sure to delete ?')}} </h4>
                        </div>
                        <input type="hidden" name="id" value="" id="classQusId">
                        <div class="mt-40 d-flex justify-content-between">
                            <button type="button" class="primary-btn tr-bg"
                                    data-bs-dismiss="modal">{{__('common.Cancel')}}</button>

                            <button class="primary-btn fix-gr-bg"
                                    type="submit">{{__('common.Delete')}}</button>

                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

@endsection
@push('scripts')

    @php
        $url = route('survey.survey-bank-list-data').'?category='.request('category').'&question_type='.request('question_type');
    @endphp

    <script>
        (function ($) {
            "use strict";
            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = '{!! $url !!}';
            dataTableOptions.columns = [
                {data: 'DT_RowIndex', name: 'id', orderable: true},

                {data: 'group_title', name: 'group_title'},
                {data: 'category_name', name: 'category.name'},
                {data: 'question', name: 'question'},
                {data: 'type', name: 'type'},
                {data: 'image', name: 'image', orderable: false},
                {data: 'action', name: 'action', orderable: false},
            ]
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4]);

            let table = $('#lms_table').DataTable(dataTableOptions);


            $(document).on('click', '.deleteQuiz_bank', function () {
                let id = $(this).data('id');
                $('#classQusId').val(id);
                $("#deleteBank").modal('show');
            });
        })(jQuery);
    </script>
    <script src="{{asset('/')}}/Modules/CourseSetting/Resources/assets/js/course.js"></script>
@endpush
