@extends('backend.master')
@php
    $table_name='survey_question_sets';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center mt-50">

                <div class="col-lg-12">

                    <div class="main-title">
                        <h3 class="mb-20">{{__('survey.Survey') }} {{__('common.List')}}</h3>
                        <ul class="d-flex">
                            @if (permissionCheck('survey.survey_store'))
                                <li>
                                    <a class="primary-btn radius_30px   fix-gr-bg"
                                       href="{{route('survey.survey_add')}}">
                                        <i class="ti-plus"></i>{{__('common.Add')}}</a>
                                </li>
                            @endif
                        </ul>
                    </div>

                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <!-- table-responsive -->
                            <div class="">
                                <table id="lms_table" class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{__('common.SL')}}</th>
                                        <th scope="col">{{__('common.Name')}}</th>

                                        <th scope="col">{{__('Survey For')}}</th>
                                         <th scope="col">{{__('common.Action')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($surveys as $index => $survey)
                                        @php
                                            if($survey->survey->title==""){
                                                continue;
                                            }
                                        @endphp
                                        <tr>
                                            <td scope="col">{{ $index+1 }}</td>
                                            <td scope="col">{{ $survey->survey->title }}</td>
                                             <td scope="col">{{ $survey->survey->available_for }}</td>

                                            <td scope="col">
                                                <div class="dropdown CRM_dropdown">
                                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                                            id="dropdownMenu2" data-bs-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                        Action
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right"
                                                         aria-labelledby="dropdownMenu2" style="">

                                                        <a href="{{ route('survey.survey_participate', $survey->id) }}"
                                                           class="dropdown-item editStudent"
                                                           type="button">Participatie</a>

                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Add Modal Item_Details -->
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')
@endsection

