<?php

namespace Modules\Survey\Entities;

use App\Traits\Tenantable;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Course;
use Modules\Org\Entities\OrgSurveyBranch;
use Modules\Org\Entities\OrgSurveyPosition;

class Survey extends Model
{
    use Tenantable;

    protected $fillable = [];


    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id', 'id')->withDefault();
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by', 'id')->withDefault();
    }

    public function assigns()
    {
        return $this->hasMany(SurveyAssign::class, 'survey_id', 'id');
    }

    public function questionAssigns()
    {
        return $this->hasMany(SurveyQuestionAssign::class, 'survey_id', 'id');
    }

    public function participants()
    {
        return $this->hasMany(SurveyAnswerSubmit::class, 'survey_id', 'id')
            ->groupBy(['survey_id', 'user_id']);
    }

    public function loginUserParticipant()
    {
        $count = $this->participants->where('user_id', \auth()->user()->id)->count();

        if ($count == 0) {
            return false;
        } else {
            return true;
        }
    }

    public function group()
    {
        return $this->belongsTo(StudentGroup::class, 'group_id', 'id')->withDefault();
    }

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($survey) {
            foreach ($survey->assigns as $key => $assign) {
                $assign->delete();
            }
        });
    }

    public function getIsPublishAttribute()
    {
        if (strtotime($this->publish_date) >= strtotime(date('m/d/Y')) && strtotime($this->publish_time) >= strtotime(date("h:i:sa"))) {
            return trans('survey.Unpublished');
        } else {
            return trans('survey.Published');
        }
    }

    public function branches()
    {
        return $this->hasMany(OrgSurveyBranch::class, 'survey_id');
    }

    public function positions()
    {
        return $this->hasMany(OrgSurveyPosition::class, 'survey_id');
    }
}
