<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Modules\Subscription\Entities\SubscriptionSetting;

class AddSubscriptioSettingColumnInGenerealSetting extends Migration
{
    public function up()
    {
        $setting = null;
        if (Schema::hasColumn('subscription_settings', 'lms_id')) {
            $setting = DB::table('subscription_settings')->where('lms_id', SaasInstitute()->id)->first();

        }
        if (!$setting) {
            $setting = DB::table('subscription_settings')->first();
        }
        if (Schema::hasColumn('general_settings', 'key')) {
            UpdateGeneralSetting('subscription_type', $setting->type);
            UpdateGeneralSetting('subscription_commission_rate', $setting->commission_rate);
            GenerateGeneralSetting(SaasDomain());
        }
    }


    public function down()
    {
        //
    }
}
