<?php

namespace Modules\Store\Repositories;

use App\Traits\Filepond;
use App\Traits\Gdrive;
use App\Traits\UploadMedia;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Modules\CourseSetting\Entities\Course;
use Modules\Store\Entities\Product;
use Modules\Store\Entities\ProductImage;
use Modules\Store\Entities\ProductSku;
use Modules\Store\Entities\ProductVariant;
use Modules\Store\interfaces\CrudInterface;

class ProductRepository implements CrudInterface
{
    use UploadMedia, Filepond, Gdrive;

    public function create(Request $request)
    {
        $product = new Product();

        foreach ($request->name as $key => $name) {
            $product->setTranslation('title', $key, $name);
        }

        foreach ($request->description as $key => $description) {
            $product->setTranslation('description', $key, $description);
        }
        foreach ($request->specification as $key => $specification) {
            $product->setTranslation('specification', $key, $specification);
        }
        foreach ($request->faq as $key => $faq) {
            $product->setTranslation('faq', $key, $faq);
        }

        $product->status = 1;
        $product->is_readable = (int)($request->is_readable ? 1 : 0);
        $product->link = $request->link;
        $product->price = $request->price ? $request->price : 0;
        $product->is_free = $request->is_free==1 ? 1 : 0;
        $product->category_id = $request->category;
        $product->sub_category_id = $request->sub_category;
        $product->type = $request->productType;
        $product->has_variant = $request->get('productOption',0)==1?1:0;
        $product->author_id = $request->product_author;
        $product->brand_id = $request->product_brand;
        $product->unit_id = $request->product_unit;
        $product->inventory_warning = $request->inventory_warning_quantity;
        $product->inventory = $request->inventory_quantity;

        $product->stock_manage = (int)$request->stock_manage ? $request->stock_manage : 0;
        $product->stock_quantity = (int)$request->stock_manage ? $request->stock_quantity : 0;

        $product->delivery_fee = $request->delv_price;
        $product->delivery_estimated_time = $request->delv_time;

        $product->discount = $request->discount ? $request->discount : 0;
        $product->discount_type = $request->discount_type;
        $product->user_id = Auth::id();
        $product->save();

        if (isset($request->thumbimage[0])) {
            $product->thumbnail = $product->image = $this->generateLink($request->thumbimage[0], $product->id, get_class($product), 'thumbnail');
        }
        if ($request->soft_file) {
            $product->soft_file = $this->generateLink($request->soft_file, $product->id, get_class($product), 'soft_file');
        }
        if ($request->pdf_file) {
            $product->pdf = $this->generateLink($request->pdf_file, $product->id, get_class($product), 'pdf');
        }
        $product->save();

        if (isset($request->thumbimage)) {
            foreach ($request->thumbimage as $key => $image) {
                $product_image = new ProductImage();
                $product_image->product_id = $product->id;
                $product_image->thumbnail = null;
                $product_image->save();
                $product_image->thumbnail = $this->generateLink($image, $product_image->id, get_class($product_image), 'thumbnail');
                $product_image->save();
            }
        }

        $product_course = new Course();
        if (isModuleActive('FrontendMultiLang')) {
            foreach ($request->name as $key => $name) {
                $product_course->setTranslation('title', $key, $name);
            }
        } else {
            $product_course->title = $request->name;
        }
        if (isModuleActive('FrontendMultiLang')) {
            foreach ($request->description as $key => $description) {
                $product_course->setTranslation('about', $key, $description);
            }
        } else {
            $product_course->about = $request->description;
        }

        $product_course->category_id = $request->category;
        $product_course->subcategory_id = $request->sub_category;
        $product_course->status = 1;
        $product_course->type = 5;
        $product_course->price = $request->price ? $request->price : 0;
        if ($request->discount) {
            if ($request->discount_type == 1) {
                $dis_price = $request->price - $request->discount;
            } else {
                $dis_price = $request->price - $request->price * $request->discount / 100;
            }
        }
        $product_course->discount_price = $request->discount ? $dis_price : 0;


        $product_course->thumbnail = $product->thumbnail;
        $product_course->image = $product->image;

        $product_course->user_id = Auth::user()->id;
        $product_course->product_id = $product->id;
        $product_course->product_type = $request->productType;

        $product_course->stock_manage = $request->stock_manage ? $request->stock_manage : 0;
        $product_course->stock_quantity = $request->stock_manage ? $request->stock_quantity : 0;

        $product_course->save();

         foreach ($request->get('track_sku',[]) as $key => $variant_sku) {

            $product_sku = new ProductSku();
            $product_sku->product_id = $product->id;
            $product_sku->sku = $request->track_sku[$key]??0;
            $product_sku->price =  $request->price_sku[$key]??0;
            $product_sku->stock =  $request->sku_stock[$key]??0;
            $product_sku->image = null;
            $product_sku->save();

            $attribute_id = explode('-', $request->str_attribute_id[0]??'');
            $attribute_value_id = explode('-', $request->str_id[$key]??0);
            foreach ($attribute_value_id as $k => $value) {
                $product_variation = new ProductVariant();
                $product_variation->product_id = $product->id;
                $product_variation->product_sku_id = $product_sku->id;
                $product_variation->attribute_id = $attribute_id[$k]??0;
                $product_variation->attribute_value_id = $attribute_value_id[$k]??0;
                $product_variation->save();
            }

        }


        return $product;
    }

    public function update(Request $request)
    {
        $product = Product::find($request->id);

        foreach ($request->name as $key => $name) {
            $product->setTranslation('title', $key, $name);
        }

        foreach ($request->description as $key => $description) {
            $product->setTranslation('description', $key, $description);
        }
        foreach ($request->specification as $key => $specification) {
            $product->setTranslation('specification', $key, $specification);
        }
        foreach ($request->faq as $key => $faq) {
            $product->setTranslation('faq', $key, $faq);
        }

        $product->is_readable = (int)($request->is_readable ? $request->readAble : 0);
        $product->link = $request->link;
        $product->price = $request->price ? $request->price : 0;
        $product->is_free = $request->is_free==1 ? 1 : 0;
        $product->category_id = $request->category;
        $product->sub_category_id = $request->sub_category;

        $product->type = $request->productType;
        $product->has_variant = $request->get('productOption',0)==1?1:0;
        $product->author_id = $request->product_author;
        $product->brand_id = $request->product_brand;
        $product->unit_id = $request->product_unit;
        $product->inventory_warning = $request->inventory_warning_quantity;
        $product->inventory = $request->inventory_quantity;

        $product->stock_manage = $request->stock_manage ? $request->stock_manage : 0;
        $product->stock_quantity = $request->stock_manage ? $request->stock_quantity : 0;

        $product->delivery_fee = $request->delv_price;
        $product->delivery_estimated_time = $request->delv_time;

        $product->thumbnail = null;
        $product->soft_file = null;
        $product->pdf = null;
        $product->user_id = Auth::user()->id;
        $product->discount = $request->discount ? $request->discount : 0;
        $product->discount_type = $request->discount_type;
        $product->save();

        if (isset($request->thumbimage[0])) {
            $product->thumbnail = $this->generateLink($request->thumbimage[0], $product->id, get_class($product), 'thumbnail');
        }
        if ($request->soft_file) {
            $product->soft_file = $this->generateLink($request->soft_file, $product->id, get_class($product), 'soft_file');
        }
        if ($request->pdf_file) {
            $product->pdf = $this->generateLink($request->pdf_file, $product->id, get_class($product), 'pdf');
        }
        $product->save();

        ProductImage::where('product_id', $request->id)->delete();

        if (isset($request->thumbimage)) {
            foreach ($request->thumbimage as $key => $image) {
                $product_image = new ProductImage();
                $product_image->product_id = $product->id;
                $product_image->thumbnail = null;
                $product_image->save();
                $product_image->thumbnail = $this->generateLink($image, $product_image->id, get_class($product_image), 'thumbnail');
                $product_image->save();
            }
        }
        $product_course = Course::where('product_id', $request->id)->first();
        if (isModuleActive('FrontendMultiLang')) {
            foreach ($request->name as $key => $name) {
                $product_course->setTranslation('title', $key, $name);
            }
        } else {
            $product_course->title = $request->name;
        }
        if (isModuleActive('FrontendMultiLang')) {
            foreach ($request->description as $key => $description) {
                $product_course->setTranslation('about', $key, $description);
            }
        } else {
            $product_course->about = $request->description;
        }

        $product_course->category_id = $request->category;
        $product_course->subcategory_id = $request->sub_category;

        $product_course->type = 5;
        $product_course->price = $request->price ? $request->price : 0;

        if ($request->discount) {
            if ($request->discount_type == 1) {
                $dis_price = $request->price - $request->discount;
            } else {
                $dis_price = $request->price - $request->price * $request->discount / 100;
            }
        }
        $product_course->discount_price = $request->discount ? $dis_price : 0;
        $product_course->lang_id = 1;

        $product_course->thumbnail = $product->thumbnail;
        $product_course->image = $product->image;

        $product_course->user_id = Auth::user()->id;
        $product_course->product_id = $product->id;
        $product_course->product_type = $request->productType;

        $product_course->stock_manage = $request->stock_manage ? $request->stock_manage : 0;
        $product_course->stock_quantity = $request->stock_manage ? $request->stock_quantity : 0;

        $product_course->save();


        ProductSku::where('product_id',$product->id)->delete();
        ProductVariant::where('product_id',$product->id)->delete();
        foreach ($request->get('track_sku',[]) as $key => $variant_sku) {

            $product_sku = new ProductSku();
            $product_sku->product_id = $product->id;
            $product_sku->sku = $request->track_sku[$key]??0;
            $product_sku->price =  $request->price_sku[$key]??0;
            $product_sku->stock =  $request->sku_stock[$key]??0;
            $product_sku->image = null;
            $product_sku->save();

            $attribute_id = explode('-', $request->str_attribute_id[0]??'');
            $attribute_value_id = explode('-', $request->str_id[$key]??0);
            foreach ($attribute_value_id as $k => $value) {
                $product_variation = new ProductVariant();
                $product_variation->product_id = $product->id;
                $product_variation->product_sku_id = $product_sku->id;
                $product_variation->attribute_id = $attribute_id[$k]??0;
                $product_variation->attribute_value_id = $attribute_value_id[$k]??0;
                $product_variation->save();
            }

        }

        return $product;
    }

    public function delete($id)
    {
    }

    public function getFilterdProduct($table)
    {
        $all_columns = Schema::getColumnListing('products');
        $exclude_columns = ['description', 'specification'];
        $get_columns = array_diff($all_columns, $exclude_columns);
        $product = Product::query()->select($get_columns);

        if ($table == 'alert') {
            return $product->where('stock_manage', 1)->whereHas('skus', function ($query) {
                return $query->select(DB::raw('SUM(product_stock) as sum_colum'))->having('sum_colum', '<=', 10);
            });
        }
        if ($table == 'stockout') {
            return $product->where('stock_manage', 1)->whereHas('skus', function ($query) {
                return $query->select(DB::raw('SUM(product_stock) as sum_colum'))->having('sum_colum', '<', 1);
            });
        }

        if ($table == 'disable') {
            return $product->where('status', 0);
        }
    }
}
