<?php

namespace Modules\Store\Repositories;

use App\Traits\UploadMedia;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\Store\Entities\ProductCategory;
use Modules\Store\interfaces\CrudInterface;

class ProductCategoryRepository implements CrudInterface
{
    use UploadMedia;

    public function create(Request $request)

    {

        $check_position = ProductCategory::where('position_order', $request->position_order)->first();

        if ($check_position != '') {
            $old_categories = ProductCategory::where('position_order', '>=', $request->position_order)->get();

            foreach ($old_categories as $old_category) {
                $old_category->position_order = $old_category->position_order + 1;
                $old_category->save();
            }
        }

        $category = new ProductCategory;

        if (isModuleActive('FrontendMultiLang')) {

            foreach ($request->name as $key => $name) {
                $category->setTranslation('title', $key, $name);
            }
        } else {
            $category->title = $request->name;
        }


        $category->position_order = $request->position_order;
        $category->status = 1;
        if (!empty($request->parent)) {
            $category->parent_id = $request->parent;
        } else {
            $category->parent_id = null;
        }


        $category->user_id = Auth::user()->id;
        $category->save();

        if ($request->image) {
            $category->image = $this->generateLink($request->image, $category->id, get_class($category), 'image');
        }
        $category->save();


        return $category;
    }

    public function delete($id)
    {

        $category = ProductCategory::find($id)->delete();
        return $category;

    }

    public function update(Request $request)
    {

        $check_position = ProductCategory::where('position_order', $request->position_order)->first();

        if ($check_position != '') {
            $old_categories = ProductCategory::where('position_order', '>=', $request->position_order)->get();

            foreach ($old_categories as $old_category) {
                $old_category->position_order = $old_category->position_order + 1;
                $old_category->save();
            }
        }
        $category = ProductCategory::find($request->id);

        if (isModuleActive('FrontendMultiLang')) {

            foreach ($request->name as $key => $name) {
                $category->setTranslation('title', $key, $name);
            }
        } else {
            $category->title = $request->name;
        }
        $category->position_order = $request->position_order;
        if (!empty($request->parent)) {
            $category->parent_id = $request->parent;
        } else {
            $category->parent_id = null;
        }

        $category->image = null;
        $category->user_id = Auth::user()->id;
        $category->save();

        if ($request->image) {
            $category->image = $this->generateLink($request->image, $category->id, get_class($category), 'image');
        }
        $category->save();
        return $category;

    }
}
