<?php

namespace Modules\Store\Http\Controllers;

use Illuminate\Routing\Controller;
use Modules\Store\Services\RefundProcessService;
use Brian2694\Toastr\Facades\Toastr;
use Modules\Store\Http\Requests\RefundProcessRequest;

class RefundProcessController extends Controller
{
    protected $refundProcessService;

    public function __construct(RefundProcessService $refundProcessService)
    {
        $this->refundProcessService = $refundProcessService;
    }

    public function index()
    {
        $data['items'] = $this->refundProcessService->getAll();
        return view('store::refund.refund_process.index', $data);
    }

    public function edit($id)
    {
        $data['edit'] = $this->refundProcessService->getById($id);
        $data['items'] = $this->refundProcessService->getAll();
        return view('store::refund.refund_process.index', $data);
    }

    public function process_list()
    {
        $data['items'] = $this->refundProcessService->getAll();
        return view('store::refund.refund_process.process_list', $data);
    }

    public function store(RefundProcessRequest $request)
    {
        try {
            $this->refundProcessService->save($request->except("_token"));
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.refundprocess.index');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function update(RefundProcessRequest $request, $id)
    {
        try {
            $this->refundProcessService->update($request->except("_token"), $id);
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.refundprocess.index');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function destroy($id)
    {
        try {
            $this->refundProcessService->delete($id);
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.refundprocess.index');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }
}
