<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RegistrationBonus\Entities\RegistrationBonusSetting;

class CreateRegistrationBonusSettingsTable extends Migration
{
    public function up()
    {
        Schema::create('registration_bonus_settings', function (Blueprint $table) {
            $table->id();
            $table->integer('is_active')->default(0);
            $table->integer('instant_bonus')->default(0);
            $table->integer('bonus_on_referrer')->default(0);
            $table->integer('bonus_on_purchase')->default(0);
            $table->integer('referrer_users')->default(0);
            $table->double('referrer_amount')->default(0);
            $table->double('bonus_amount')->default(0);
            $table->timestamps();
        });

        $have_one = RegistrationBonusSetting::first();
        if (!$have_one) {
            RegistrationBonusSetting::create([
                "is_active" => 0,
                "instant_bonus" => 0,
                "bonus_on_referrer" => 0,
                "bonus_on_purchase" => 0,
                "referrer_users" => 0,
                "referrer_amount" => 0,
                "bonus_amount" => 0,
            ]);
        }
    }

    public function down()
    {
        Schema::dropIfExists('registration_bonus_settings');
    }
}
