<?php

namespace Modules\Installment\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Contracts\Support\Renderable;

class InstallmentSettingController extends Controller
{
    public function index()
    {
        $data = [];
        $data['title'] = _trans('installment.Installment Settings');
        return view('installment::settings.index', compact('data'));
    }

    public function update(Request $request)
    {
        try {
            $request_fields = [
                'installment_active' => $request->installment_active ?? 0,
                'installment_disable_course' => $request->installment_disable_course ?? 0,
                'installment_disable_all_course' => $request->installment_disable_all_course ?? 0,
                'disable_installment' => $request->disable_installment ?? 0,
                'display_installment_button' => $request->display_installment_button ?? 0,
                'overdue_interval' => $request->overdue_interval ?? 0,
                'installment_plan_position' => $request->installment_plan_position ?? 0,
                'installment_reminder_days_before' => $request->installment_reminder_days_before ?? 0,
                'installment_reminder_days_after_due' => $request->installment_reminder_days_before ?? 0,
                'installment_terms_policy' => $request->installment_terms_policy ?? 0,
            ];
            foreach ($request_fields as $key => $setup) {
                UpdateGeneralSetting($key, $setup);
            }
            Toastr::success(_trans('installment.Installment Settings Updated successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Throwable $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

}
