<?php if(permissionCheck('noticeboard.course.store')): ?>
    <div class="modal fade admin-query" id="add_noticeboard">
        <div class="modal-dialog modal_1000px modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo e(__('common.Add')); ?> <?php if($group==2): ?>
                            <?php echo e(__('courses.Course')); ?>

                        <?php else: ?>
                            <?php echo e(__('noticeboard.General')); ?>

                        <?php endif; ?> <?php echo e(__('noticeboard.Noticeboard')); ?></h4>
                    <button type="button" class="close " data-bs-dismiss="modal">
                        <i class="ti-close "></i>
                    </button>
                </div>

                <div class="modal-body">
                    <form action="<?php echo e(route($group==2?'noticeboard.course.store':'noticeboard.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="group" value="<?php echo e($group); ?>">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for=""><?php echo e(__('common.Title')); ?>

                                        <strong
                                            class="text-danger">*</strong></label>
                                    <input class="primary_input_field" name="title" placeholder="-"
                                           type="text" id=""
                                           value="<?php echo e(old('title')); ?>" <?php echo e($errors->first('title') ? 'autofocus' : ''); ?>>
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for=""><?php echo e(__('common.Type')); ?>

                                        <strong
                                            class="text-danger">*</strong></label>

                                    <select <?php echo e($errors->has('type') ? ' autofocus' : ''); ?>

                                            class="primary_select <?php echo e($errors->has('type') ? ' is-invalid' : ''); ?>"
                                            id="" name="type">
                                        <option data-display="<?php echo e(__('common.Type')); ?> *"
                                                value="">  <?php echo e(__('common.Type')); ?>

                                        </option>
                                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($type); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <?php if($group==2): ?>
                                <div class="col-xl-12 mb-25 mt-25">
                                    <label class="primary_input_label" for=""> <?php echo e(__('common.Course')); ?>

                                        <strong
                                            class="text-danger">*</strong></label>
                                    <select name="course_id[]"
                                            class="multypol_check_select active mb-15 e1" multiple>
                                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($course); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            <?php elseif($group==1): ?>
                                <div class="col-xl-12 mb-25 mt-25">
                                    <label class="primary_input_label" for=""> <?php echo e(__('common.Role')); ?>

                                        <strong
                                            class="text-danger">*</strong></label>
                                    <select name="role_id[]"
                                            class="multypol_check_select active mb-15 e1" multiple>
                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($role); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            <?php endif; ?>
                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for=""><?php echo e(__('noticeboard.Message')); ?>

                                        <strong
                                            class="text-danger">*</strong></label>
                                    <textarea name="message" class="lms_summernote"></textarea>
                                </div>
                            </div>


                        </div>

                        <div class="col-lg-12 text-center pt_15">
                            <div class="d-flex justify-content-center">
                                <button class="primary-btn semi_large2  fix-gr-bg"
                                        id="save_button_parent"
                                        type="submit"><i
                                        class="ti-check"></i> <?php echo e(__('common.Save')); ?> <?php if($group==2): ?>
                                        <?php echo e(__('courses.Course')); ?>

                                    <?php else: ?>
                                        <?php echo e(__('noticeboard.General')); ?>

                                    <?php endif; ?> <?php echo e(__('noticeboard.Noticeboard')); ?>

                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/minialms/card.minialms.com/Modules/Noticeboard/Resources/views/notice/_add_modal.blade.php ENDPATH**/ ?>