<?php $__env->startSection('mainContent'); ?>
    <?php echo generateBreadcrumb(); ?>


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="main-title d-md-flex justify-content-md-between mb-20">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title"><?php echo e($data['title']); ?></h3>
                            <ul class="d-flex">
                                <li>
                                    <a class="primary-btn radius_30px fix-gr-bg"
                                       href="<?php echo e(route('installment.plan.create')); ?>"><i
                                            class="ti-plus"></i><?php echo e(_trans('installment.Add Plan')); ?> </a>
                                </li>
                            </ul>

                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <?php $__currentLoopData = $data['table_columns']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $th): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th scope="col"><?php echo e($th); ?></th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $data['plans']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th><?php echo e($key + 1); ?></th>

                                                <td><?php echo e(@$plan->getTranslation('title', auth()->user()->language_code ?? 'en')); ?></td>
                                                <td><?php echo e(@$plan->sales ?? 0); ?></td>
                                                <td>
                                                    <?php
                                                        $upfront = @$plan->paymentSteps->where('payment_title', 'Upfront')->first();
                                                    ?>
                                                    <?php echo e($upfront->amount_type == 'percent' ? $upfront->payment_amount . '%' : getPriceFormat($upfront->payment_amount)); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($plan->paymentSteps->count() > 1 ? $plan->paymentSteps->count() - 1 : 0); ?>

                                                </td>
                                                <td>
                                                    <?php
                                                        $installment_amount = $plan->paymentSteps->where('payment_title', '!=', 'Upfront')->sum('payment_amount');
                                                    ?>
                                                    <?php echo e($upfront->amount_type == 'percent' ? $installment_amount . '%' : getPriceFormat($installment_amount)); ?>

                                                </td>
                                                <td>
                                                    <?php echo e(@$plan->capacity); ?>

                                                </td>
                                                <td><?php echo e(showDate($plan->start_datetime) . ' | ' . showTime($plan->start_datetime)); ?>

                                                </td>
                                                <td><?php echo e($plan->end_datetime != null ? showDate($plan->end_datetime) . ' | ' . showTime($plan->end_datetime) : '-'); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($plan->statusText); ?>

                                                </td>
                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            <?php echo e(__('common.Select')); ?>

                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            <?php if(permissionCheck('installment.plan.edit')): ?>
                                                                <a class="dropdown-item edit_brand"
                                                                   href="<?php echo e(route('installment.plan.edit', @$plan->id)); ?>"><?php echo e(_trans('common.Edit')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if(permissionCheck('installment.plan.delete')): ?>
                                                                <a class="dropdown-item" data-bs-toggle="modal"
                                                                   data-bs-target="#deleteQuestionGroupModal<?php echo e(@$plan->id); ?>"
                                                                   href="#"><?php echo e(__('common.Delete')); ?></a>
                                                            <?php endif; ?>

                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>

                                            <div class="modal fade admin-query"
                                                 id="deleteQuestionGroupModal<?php echo e($plan->id); ?>">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"><?php echo e(__('common.Delete')); ?>

                                                                <?php echo e(_trans('installment.Installment')); ?>

                                                                <?php echo e(_trans('installment.Plan')); ?></h4>
                                                            <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal"><i
                                                                    class="ti-close "></i></button>
                                                        </div>

                                                        <div class="modal-body">
                                                            <div class="text-center">
                                                                <h4> <?php echo e(__('common.Are you sure to delete ?')); ?></h4>
                                                            </div>

                                                            <div class="mt-40 d-flex justify-content-between">
                                                                <button type="button" class="primary-btn tr-bg"
                                                                        data-bs-dismiss="modal"><?php echo e(__('common.Cancel')); ?></button>


                                                                <form method="POST"
                                                                      action="<?php echo e(route('installment.plan.delete')); ?>"
                                                                      enctype="multipart/form-data">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="id"
                                                                           value="<?php echo e($plan->id); ?>">
                                                                    <button class="primary-btn fix-gr-bg"
                                                                            type="submit"><?php echo e(__('common.Delete')); ?></button>
                                                                </form>

                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="<?php echo e(route('coupons.status_update')); ?>">

    <?php echo $__env->make('backend.partials.delete_modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script type="application/javascript">
        (function ($) {
            "use strict";

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5, 6, 7, 8]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Installment/Resources/views/plan/index.blade.php ENDPATH**/ ?>