<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCountriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name', 100)->nullable();
            $table->string('iso3', 10)->nullable();
            $table->string('iso2', 10)->nullable();
            $table->string('phonecode', 30)->nullable();
            $table->string('currency', 30)->nullable();
            $table->string('capital', 50)->nullable();
            $table->tinyInteger('active_status')->nullable();
            $table->timestamps();
        });


        DB::statement("INSERT INTO countries (id, name, iso3, iso2, phonecode, capital, currency, created_at, updated_at, active_status) VALUES(1, 'Afghanistan', 'AFG', 'AF', '93', 'Kabul', 'AFN', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (2, 'Aland Islands', 'ALA', 'AX', '+358-18', 'Mariehamn', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (3, 'Albania', 'ALB', 'AL', '355', 'Tirana', 'ALL', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (4, 'Algeria', 'DZA', 'DZ', '213', 'Algiers', 'DZD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (5, 'American Samoa', 'ASM', 'AS', '+1-684', 'Pago Pago', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (6, 'Andorra', 'AND', 'AD', '376', 'Andorra la Vella', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (7, 'Angola', 'AGO', 'AO', '244', 'Luanda', 'AOA', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (8, 'Anguilla', 'AIA', 'AI', '+1-264', 'The Valley', 'XCD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (9, 'Antarctica', 'ATA', 'AQ', '', '', '', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (10, 'Antigua And Barbuda', 'ATG', 'AG', '+1-268', 'St. Johns', 'XCD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (11, 'Argentina', 'ARG', 'AR', '54', 'Buenos Aires', 'ARS', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (12, 'Armenia', 'ARM', 'AM', '374', 'Yerevan', 'AMD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (13, 'Aruba', 'ABW', 'AW', '297', 'Oranjestad', 'AWG', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (14, 'Australia', 'AUS', 'AU', '61', 'Canberra', 'AUD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (15, 'Austria', 'AUT', 'AT', '43', 'Vienna', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (16, 'Azerbaijan', 'AZE', 'AZ', '994', 'Baku', 'AZN', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (17, 'Bahamas The', 'BHS', 'BS', '+1-242', 'Nassau', 'BSD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (18, 'Bahrain', 'BHR', 'BH', '973', 'Manama', 'BHD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (19, 'Bangladesh', 'BGD', 'BD', '880', 'Dhaka', 'BDT', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (20, 'Barbados', 'BRB', 'BB', '+1-246', 'Bridgetown', 'BBD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (21, 'Belarus', 'BLR', 'BY', '375', 'Minsk', 'BYR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (22, 'Belgium', 'BEL', 'BE', '32', 'Brussels', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (23, 'Belize', 'BLZ', 'BZ', '501', 'Belmopan', 'BZD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (24, 'Benin', 'BEN', 'BJ', '229', 'Porto-Novo', 'XOF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (25, 'Bermuda', 'BMU', 'BM', '+1-441', 'Hamilton', 'BMD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (26, 'Bhutan', 'BTN', 'BT', '975', 'Thimphu', 'BTN', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (27, 'Bolivia', 'BOL', 'BO', '591', 'Sucre', 'BOB', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (28, 'Bosnia and Herzegovina', 'BIH', 'BA', '387', 'Sarajevo', 'BAM', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (29, 'Botswana', 'BWA', 'BW', '267', 'Gaborone', 'BWP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (30, 'Bouvet Island', 'BVT', 'BV', '', '', 'NOK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (31, 'Brazil', 'BRA', 'BR', '55', 'Brasilia', 'BRL', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (32, 'British Indian Ocean Territory', 'IOT', 'IO', '246', 'Diego Garcia', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (33, 'Brunei', 'BRN', 'BN', '673', 'Bandar Seri Begawan', 'BND', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (34, 'Bulgaria', 'BGR', 'BG', '359', 'Sofia', 'BGN', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (35, 'Burkina Faso', 'BFA', 'BF', '226', 'Ouagadougou', 'XOF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (36, 'Burundi', 'BDI', 'BI', '257', 'Bujumbura', 'BIF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (37, 'Cambodia', 'KHM', 'KH', '855', 'Phnom Penh', 'KHR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (38, 'Cameroon', 'CMR', 'CM', '237', 'Yaounde', 'XAF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (39, 'Canada', 'CAN', 'CA', '1', 'Ottawa', 'CAD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (40, 'Cape Verde', 'CPV', 'CV', '238', 'Praia', 'CVE', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (41, 'Cayman Islands', 'CYM', 'KY', '+1-345', 'George Town', 'KYD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (42, 'Central African Republic', 'CAF', 'CF', '236', 'Bangui', 'XAF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (43, 'Chad', 'TCD', 'TD', '235', 'NDjamena', 'XAF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (44, 'Chile', 'CHL', 'CL', '56', 'Santiago', 'CLP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (45, 'China', 'CHN', 'CN', '86', 'Beijing', 'CNY', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (46, 'Christmas Island', 'CXR', 'CX', '61', 'Flying Fish Cove', 'AUD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (47, 'Cocos (Keeling) Islands', 'CCK', 'CC', '61', 'West Island', 'AUD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (48, 'Colombia', 'COL', 'CO', '57', 'Bogota', 'COP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (49, 'Comoros', 'COM', 'KM', '269', 'Moroni', 'KMF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (50, 'Congo', 'COG', 'CG', '242', 'Brazzaville', 'XAF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (51, 'Congo The Democratic Republic Of The', 'COD', 'CD', '243', 'Kinshasa', 'CDF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (52, 'Cook Islands', 'COK', 'CK', '682', 'Avarua', 'NZD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (53, 'Costa Rica', 'CRI', 'CR', '506', 'San Jose', 'CRC', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (54, 'Cote DIvoire (Ivory Coast)', 'CIV', 'CI', '225', 'Yamoussoukro', 'XOF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (55, 'Croatia (Hrvatska)', 'HRV', 'HR', '385', 'Zagreb', 'HRK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (56, 'Cuba', 'CUB', 'CU', '53', 'Havana', 'CUP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (57, 'Cyprus', 'CYP', 'CY', '357', 'Nicosia', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (58, 'Czech Republic', 'CZE', 'CZ', '420', 'Prague', 'CZK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (59, 'Denmark', 'DNK', 'DK', '45', 'Copenhagen', 'DKK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (60, 'Djibouti', 'DJI', 'DJ', '253', 'Djibouti', 'DJF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (61, 'Dominica', 'DMA', 'DM', '+1-767', 'Roseau', 'XCD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (62, 'Dominican Republic', 'DOM', 'DO', '+1-809 and 1-829', 'Santo Domingo', 'DOP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (63, 'East Timor', 'TLS', 'TL', '670', 'Dili', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (64, 'Ecuador', 'ECU', 'EC', '593', 'Quito', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (65, 'Egypt', 'EGY', 'EG', '20', 'Cairo', 'EGP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (66, 'El Salvador', 'SLV', 'SV', '503', 'San Salvador', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (67, 'Equatorial Guinea', 'GNQ', 'GQ', '240', 'Malabo', 'XAF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (68, 'Eritrea', 'ERI', 'ER', '291', 'Asmara', 'ERN', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (69, 'Estonia', 'EST', 'EE', '372', 'Tallinn', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (70, 'Ethiopia', 'ETH', 'ET', '251', 'Addis Ababa', 'ETB', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (71, 'Falkland Islands', 'FLK', 'FK', '500', 'Stanley', 'FKP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (72, 'Faroe Islands', 'FRO', 'FO', '298', 'Torshavn', 'DKK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (73, 'Fiji Islands', 'FJI', 'FJ', '679', 'Suva', 'FJD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (74, 'Finland', 'FIN', 'FI', '358', 'Helsinki', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (75, 'France', 'FRA', 'FR', '33', 'Paris', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (76, 'French Guiana', 'GUF', 'GF', '594', 'Cayenne', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (77, 'French Polynesia', 'PYF', 'PF', '689', 'Papeete', 'XPF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (78, 'French Southern Territories', 'ATF', 'TF', '', 'Port-aux-Francais', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (79, 'Gabon', 'GAB', 'GA', '241', 'Libreville', 'XAF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (80, 'Gambia The', 'GMB', 'GM', '220', 'Banjul', 'GMD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (81, 'Georgia', 'GEO', 'GE', '995', 'Tbilisi', 'GEL', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (82, 'Germany', 'DEU', 'DE', '49', 'Berlin', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (83, 'Ghana', 'GHA', 'GH', '233', 'Accra', 'GHS', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (84, 'Gibraltar', 'GIB', 'GI', '350', 'Gibraltar', 'GIP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (85, 'Greece', 'GRC', 'GR', '30', 'Athens', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (86, 'Greenland', 'GRL', 'GL', '299', 'Nuuk', 'DKK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (87, 'Grenada', 'GRD', 'GD', '+1-473', 'St. Georges', 'XCD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (88, 'Guadeloupe', 'GLP', 'GP', '590', 'Basse-Terre', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (89, 'Guam', 'GUM', 'GU', '+1-671', 'Hagatna', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (90, 'Guatemala', 'GTM', 'GT', '502', 'Guatemala City', 'GTQ', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (91, 'Guernsey and Alderney', 'GGY', 'GG', '+44-1481', 'St Peter Port', 'GBP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (92, 'Guinea', 'GIN', 'GN', '224', 'Conakry', 'GNF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (93, 'Guinea-Bissau', 'GNB', 'GW', '245', 'Bissau', 'XOF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (94, 'Guyana', 'GUY', 'GY', '592', 'Georgetown', 'GYD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (95, 'Haiti', 'HTI', 'HT', '509', 'Port-au-Prince', 'HTG', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (96, 'Heard and McDonald Islands', 'HMD', 'HM', ' ', '', 'AUD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (97, 'Honduras', 'HND', 'HN', '504', 'Tegucigalpa', 'HNL', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (98, 'Hong Kong S.A.R.', 'HKG', 'HK', '852', 'Hong Kong', 'HKD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (99, 'Hungary', 'HUN', 'HU', '36', 'Budapest', 'HUF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (100, 'Iceland', 'ISL', 'IS', '354', 'Reykjavik', 'ISK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (101, 'India', 'IND', 'IN', '91', 'New Delhi', 'INR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (102, 'Indonesia', 'IDN', 'ID', '62', 'Jakarta', 'IDR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (103, 'Iran', 'IRN', 'IR', '98', 'Tehran', 'IRR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (104, 'Iraq', 'IRQ', 'IQ', '964', 'Baghdad', 'IQD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (105, 'Ireland', 'IRL', 'IE', '353', 'Dublin', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (106, 'Israel', 'ISR', 'IL', '972', 'Jerusalem', 'ILS', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (107, 'Italy', 'ITA', 'IT', '39', 'Rome', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (108, 'Jamaica', 'JAM', 'JM', '+1-876', 'Kingston', 'JMD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (109, 'Japan', 'JPN', 'JP', '81', 'Tokyo', 'JPY', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (110, 'Jersey', 'JEY', 'JE', '+44-1534', 'Saint Helier', 'GBP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (111, 'Jordan', 'JOR', 'JO', '962', 'Amman', 'JOD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (112, 'Kazakhstan', 'KAZ', 'KZ', '7', 'Astana', 'KZT', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (113, 'Kenya', 'KEN', 'KE', '254', 'Nairobi', 'KES', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (114, 'Kiribati', 'KIR', 'KI', '686', 'Tarawa', 'AUD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (115, 'Korea North\n', 'PRK', 'KP', '850', 'Pyongyang', 'KPW', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (116, 'Korea South', 'KOR', 'KR', '82', 'Seoul', 'KRW', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (117, 'Kuwait', 'KWT', 'KW', '965', 'Kuwait City', 'KWD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (118, 'Kyrgyzstan', 'KGZ', 'KG', '996', 'Bishkek', 'KGS', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (119, 'Laos', 'LAO', 'LA', '856', 'Vientiane', 'LAK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (120, 'Latvia', 'LVA', 'LV', '371', 'Riga', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (121, 'Lebanon', 'LBN', 'LB', '961', 'Beirut', 'LBP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (122, 'Lesotho', 'LSO', 'LS', '266', 'Maseru', 'LSL', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (123, 'Liberia', 'LBR', 'LR', '231', 'Monrovia', 'LRD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (124, 'Libya', 'LBY', 'LY', '218', 'Tripolis', 'LYD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (125, 'Liechtenstein', 'LIE', 'LI', '423', 'Vaduz', 'CHF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (126, 'Lithuania', 'LTU', 'LT', '370', 'Vilnius', 'LTL', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (127, 'Luxembourg', 'LUX', 'LU', '352', 'Luxembourg', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (128, 'Macau S.A.R.', 'MAC', 'MO', '853', 'Macao', 'MOP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (129, 'Macedonia', 'MKD', 'MK', '389', 'Skopje', 'MKD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (130, 'Madagascar', 'MDG', 'MG', '261', 'Antananarivo', 'MGA', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (131, 'Malawi', 'MWI', 'MW', '265', 'Lilongwe', 'MWK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (132, 'Malaysia', 'MYS', 'MY', '60', 'Kuala Lumpur', 'MYR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (133, 'Maldives', 'MDV', 'MV', '960', 'Male', 'MVR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (134, 'Mali', 'MLI', 'ML', '223', 'Bamako', 'XOF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (135, 'Malta', 'MLT', 'MT', '356', 'Valletta', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (136, 'Man (Isle of)', 'IMN', 'IM', '+44-1624', 'Douglas, Isle of Man', 'GBP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (137, 'Marshall Islands', 'MHL', 'MH', '692', 'Majuro', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (138, 'Martinique', 'MTQ', 'MQ', '596', 'Fort-de-France', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (139, 'Mauritania', 'MRT', 'MR', '222', 'Nouakchott', 'MRO', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (140, 'Mauritius', 'MUS', 'MU', '230', 'Port Louis', 'MUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (141, 'Mayotte', 'MYT', 'YT', '262', 'Mamoudzou', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (142, 'Mexico', 'MEX', 'MX', '52', 'Mexico City', 'MXN', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (143, 'Micronesia', 'FSM', 'FM', '691', 'Palikir', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (144, 'Moldova', 'MDA', 'MD', '373', 'Chisinau', 'MDL', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (145, 'Monaco', 'MCO', 'MC', '377', 'Monaco', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (146, 'Mongolia', 'MNG', 'MN', '976', 'Ulan Bator', 'MNT', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (147, 'Montenegro', 'MNE', 'ME', '382', 'Podgorica', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (148, 'Montserrat', 'MSR', 'MS', '+1-664', 'Plymouth', 'XCD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (149, 'Morocco', 'MAR', 'MA', '212', 'Rabat', 'MAD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (150, 'Mozambique', 'MOZ', 'MZ', '258', 'Maputo', 'MZN', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (151, 'Myanmar', 'MMR', 'MM', '95', 'Nay Pyi Taw', 'MMK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (152, 'Namibia', 'NAM', 'NA', '264', 'Windhoek', 'NAD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (153, 'Nauru', 'NRU', 'NR', '674', 'Yaren', 'AUD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (154, 'Nepal', 'NPL', 'NP', '977', 'Kathmandu', 'NPR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (155, 'Netherlands Antilles', 'ANT', 'AN', '', '', '', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (156, 'Netherlands The', 'NLD', 'NL', '31', 'Amsterdam', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (157, 'New Caledonia', 'NCL', 'NC', '687', 'Noumea', 'XPF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (158, 'New Zealand', 'NZL', 'NZ', '64', 'Wellington', 'NZD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (159, 'Nicaragua', 'NIC', 'NI', '505', 'Managua', 'NIO', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (160, 'Niger', 'NER', 'NE', '227', 'Niamey', 'XOF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (161, 'Nigeria', 'NGA', 'NG', '234', 'Abuja', 'NGN', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (162, 'Niue', 'NIU', 'NU', '683', 'Alofi', 'NZD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (163, 'Norfolk Island', 'NFK', 'NF', '672', 'Kingston', 'AUD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (164, 'Northern Mariana Islands', 'MNP', 'MP', '+1-670', 'Saipan', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (165, 'Norway', 'NOR', 'NO', '47', 'Oslo', 'NOK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (166, 'Oman', 'OMN', 'OM', '968', 'Muscat', 'OMR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (167, 'Pakistan', 'PAK', 'PK', '92', 'Islamabad', 'PKR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (168, 'Palau', 'PLW', 'PW', '680', 'Melekeok', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (169, 'Palestinian Territory Occupied', 'PSE', 'PS', '970', 'East Jerusalem', 'ILS', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (170, 'Panama', 'PAN', 'PA', '507', 'Panama City', 'PAB', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (171, 'Papua new Guinea', 'PNG', 'PG', '675', 'Port Moresby', 'PGK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (172, 'Paraguay', 'PRY', 'PY', '595', 'Asuncion', 'PYG', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (173, 'Peru', 'PER', 'PE', '51', 'Lima', 'PEN', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (174, 'Philippines', 'PHL', 'PH', '63', 'Manila', 'PHP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (175, 'Pitcairn Island', 'PCN', 'PN', '870', 'Adamstown', 'NZD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (176, 'Poland', 'POL', 'PL', '48', 'Warsaw', 'PLN', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (177, 'Portugal', 'PRT', 'PT', '351', 'Lisbon', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (178, 'Puerto Rico', 'PRI', 'PR', '+1-787 and 1-939', 'San Juan', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (179, 'Qatar', 'QAT', 'QA', '974', 'Doha', 'QAR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (180, 'Reunion', 'REU', 'RE', '262', 'Saint-Denis', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (181, 'Romania', 'ROU', 'RO', '40', 'Bucharest', 'RON', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (182, 'Russia', 'RUS', 'RU', '7', 'Moscow', 'RUB', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (183, 'Rwanda', 'RWA', 'RW', '250', 'Kigali', 'RWF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (184, 'Saint Helena', 'SHN', 'SH', '290', 'Jamestown', 'SHP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (185, 'Saint Kitts And Nevis', 'KNA', 'KN', '+1-869', 'Basseterre', 'XCD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (186, 'Saint Lucia', 'LCA', 'LC', '+1-758', 'Castries', 'XCD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (187, 'Saint Pierre and Miquelon', 'SPM', 'PM', '508', 'Saint-Pierre', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (188, 'Saint Vincent And The Grenadines', 'VCT', 'VC', '+1-784', 'Kingstown', 'XCD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (189, 'Saint-Barthelemy', 'BLM', 'BL', '590', 'Gustavia', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (190, 'Saint-Martin (French part)', 'MAF', 'MF', '590', 'Marigot', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (191, 'Samoa', 'WSM', 'WS', '685', 'Apia', 'WST', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (192, 'San Marino', 'SMR', 'SM', '378', 'San Marino', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (193, 'Sao Tome and Principe', 'STP', 'ST', '239', 'Sao Tome', 'STD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (194, 'Saudi Arabia', 'SAU', 'SA', '966', 'Riyadh', 'SAR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (195, 'Senegal', 'SEN', 'SN', '221', 'Dakar', 'XOF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (196, 'Serbia', 'SRB', 'RS', '381', 'Belgrade', 'RSD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (197, 'Seychelles', 'SYC', 'SC', '248', 'Victoria', 'SCR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (198, 'Sierra Leone', 'SLE', 'SL', '232', 'Freetown', 'SLL', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (199, 'Singapore', 'SGP', 'SG', '65', 'Singapur', 'SGD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (200, 'Slovakia', 'SVK', 'SK', '421', 'Bratislava', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (201, 'Slovenia', 'SVN', 'SI', '386', 'Ljubljana', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (202, 'Solomon Islands', 'SLB', 'SB', '677', 'Honiara', 'SBD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (203, 'Somalia', 'SOM', 'SO', '252', 'Mogadishu', 'SOS', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (204, 'South Africa', 'ZAF', 'ZA', '27', 'Pretoria', 'ZAR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (205, 'South Georgia', 'SGS', 'GS', '', 'Grytviken', 'GBP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (206, 'South Sudan', 'SSD', 'SS', '211', 'Juba', 'SSP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (207, 'Spain', 'ESP', 'ES', '34', 'Madrid', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (208, 'Sri Lanka', 'LKA', 'LK', '94', 'Colombo', 'LKR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (209, 'Sudan', 'SDN', 'SD', '249', 'Khartoum', 'SDG', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (210, 'Suriname', 'SUR', 'SR', '597', 'Paramaribo', 'SRD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (211, 'Svalbard And Jan Mayen Islands', 'SJM', 'SJ', '47', 'Longyearbyen', 'NOK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (212, 'Swaziland', 'SWZ', 'SZ', '268', 'Mbabane', 'SZL', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (213, 'Sweden', 'SWE', 'SE', '46', 'Stockholm', 'SEK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (214, 'Switzerland', 'CHE', 'CH', '41', 'Berne', 'CHF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (215, 'Syria', 'SYR', 'SY', '963', 'Damascus', 'SYP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (216, 'Taiwan', 'TWN', 'TW', '886', 'Taipei', 'TWD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (217, 'Tajikistan', 'TJK', 'TJ', '992', 'Dushanbe', 'TJS', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (218, 'Tanzania', 'TZA', 'TZ', '255', 'Dodoma', 'TZS', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (219, 'Thailand', 'THA', 'TH', '66', 'Bangkok', 'THB', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (220, 'Togo', 'TGO', 'TG', '228', 'Lome', 'XOF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (221, 'Tokelau', 'TKL', 'TK', '690', '', 'NZD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (222, 'Tonga', 'TON', 'TO', '676', 'Nukualofa', 'TOP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (223, 'Trinidad And Tobago', 'TTO', 'TT', '+1-868', 'Port of Spain', 'TTD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (224, 'Tunisia', 'TUN', 'TN', '216', 'Tunis', 'TND', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (225, 'Turkey', 'TUR', 'TR', '90', 'Ankara', 'TRY', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (226, 'Turkmenistan', 'TKM', 'TM', '993', 'Ashgabat', 'TMT', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (227, 'Turks And Caicos Islands', 'TCA', 'TC', '+1-649', 'Cockburn Town', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (228, 'Tuvalu', 'TUV', 'TV', '688', 'Funafuti', 'AUD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (229, 'Uganda', 'UGA', 'UG', '256', 'Kampala', 'UGX', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (230, 'Ukraine', 'UKR', 'UA', '380', 'Kiev', 'UAH', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (231, 'United Arab Emirates', 'ARE', 'AE', '971', 'Abu Dhabi', 'AED', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (232, 'United Kingdom', 'GBR', 'GB', '44', 'London', 'GBP', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (233, 'United States', 'USA', 'US', '1', 'Washington', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (234, 'United States Minor Outlying Islands', 'UMI', 'UM', '1', '', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (235, 'Uruguay', 'URY', 'UY', '598', 'Montevideo', 'UYU', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (236, 'Uzbekistan', 'UZB', 'UZ', '998', 'Tashkent', 'UZS', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (237, 'Vanuatu', 'VUT', 'VU', '678', 'Port Vila', 'VUV', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (238, 'Vatican City State (Holy See)', 'VAT', 'VA', '379', 'Vatican City', 'EUR', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (239, 'Venezuela', 'VEN', 'VE', '58', 'Caracas', 'VEF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (240, 'Vietnam', 'VNM', 'VN', '84', 'Hanoi', 'VND', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (241, 'Virgin Islands (British)', 'VGB', 'VG', '+1-284', 'Road Town', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (242, 'Virgin Islands (US)', 'VIR', 'VI', '+1-340', 'Charlotte Amalie', 'USD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (243, 'Wallis And Futuna Islands', 'WLF', 'WF', '681', 'Mata Utu', 'XPF', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (244, 'Western Sahara', 'ESH', 'EH', '212', 'El-Aaiun', 'MAD', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (245, 'Yemen', 'YEM', 'YE', '967', 'Sanaa', 'YER', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (246, 'Zambia', 'ZMB', 'ZM', '260', 'Lusaka', 'ZMK', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1),
        (247, 'Zimbabwe', 'ZWE', 'ZW', '263', 'Harare', 'ZWL', '2018-07-20 14:41:03', '2018-07-20 14:41:03', 1)");


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('countries');
    }
}
