@extends('backend.master')
@section('mainContent')

    {{generateBreadcrumb()}}
    <section class="mb-40 up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row row-gap-4 mb-5">
                <div class="col-lg-4 col-md-6 col-sm-6">
                    <a href="#" class="d-block">
                        <div class="white-box single-summery">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3>{{ __('whatsapp.total_click') }}</h3>
                                    <p class="mb-0 invisible">{{ __('whatsapp.clicks') }}</p>
                                </div>
                                <h1 class="gradient-color2">
                                    {{ translatedNumber($messages->count()) }}
                                </h1>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-6">
                    <a href="#" class="d-block">
                        <div class="white-box single-summery">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3>{{ __('whatsapp.click_from_mobile') }}</h3>
                                    <p class="mb-0 invisible">{{ __('whatsapp.clicks') }}</p>
                                </div>
                                <h1 class="gradient-color2">
                                    {{ translatedNumber($messages->where('device_type', 'Mobile')->count()) }}
                                </h1>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-6">
                    <a href="#" class="d-block">
                        <div class="white-box single-summery">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3>{{ __('whatsapp.click_from_desktop') }}</h3>
                                    <p class="mb-0 invisible">{{ __('whatsapp.clicks') }}</p>
                                </div>
                                <h1 class="gradient-color2">
                                    {{ translatedNumber($messages->where('device_type', 'Desktop')->count()) }}
                                </h1>
                            </div>
                        </div>
                    </a>
                </div>

            </div>
            <div class="white-box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex">
                                <h3 class="mb-0 mr-30" id="page_title">{{ __('whatsapp.analytics') }}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id=" " class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('whatsapp.id') }}</th>
                                            <th scope="col">{{ __('whatsapp.ip') }}</th>
                                            <th scope="col">{{ __('whatsapp.browser') }}</th>
                                            <th scope="col">{{ __('whatsapp.operating_system') }}</th>
                                            <th scope="col">{{ __('whatsapp.messages') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($messages as $index => $message)
                                            <tr>
                                                <th>{{ translatedNumber($index+1) }}</th>
                                                <td>{{ $message->ip }}</td>
                                                <td>{{ $message->browser }}</td>
                                                <td>{{ $message->os }}</td>
                                                <td>{{ $message->message }}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
@endsection
@push('scripts')
    <script type="application/javascript">


        dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4,]);

        let table = $('#lms_table').DataTable(dataTableOptions);


    </script>
@endpush
