<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::table('whatsapp_support_agents', function ($table) {
            if (!Schema::hasColumn('whatsapp_support_agents', 'type')) {
                $table->tinyInteger('type')->default(1);
            }
            if (!Schema::hasColumn('whatsapp_support_agents', 'url')) {
                $table->string('url')->nullable();
            }
        });


        Schema::table('whatsapp_support_settings', function ($table) {
            if (!Schema::hasColumn('whatsapp_support_settings', 'whatsapp_logo')) {
                $table->string('whatsapp_logo')->nullable();
            }
        });
    }

    public function down(): void
    {
        //
    }
};
