<?php

namespace Modules\SupportTicket\Http\Controllers;

use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\SupportTicket\Entities\SupportTicket;
use Modules\SupportTicket\Entities\TicketCategory;
use Modules\SupportTicket\Entities\TicketStatus;
use Modules\SupportTicket\Services\SupportTicketService;

class UserSupportTicketController extends Controller
{
    protected $supportTicketService;

    public function __construct(SupportTicketService $supportTicketService)
    {
        $this->supportTicketService = $supportTicketService;
    }

    public function index()
    {

        $tickets = $this->supportTicketService->ticketListByAuth()->get();
        $data['userTickets'] = $tickets;
        $data['closedTickets'] = $tickets->where('status_id', 4);
        $data['activeTickets'] = $tickets->where('status_id', '!=', 4);
        $data['CategoryList'] = $this->supportTicketService->categoryList();
        $data['PriorityList'] = $this->supportTicketService->priorityList();
        $data['StatusList'] = $this->supportTicketService->statusList();
        return view(theme('pages.support-ticket-list'), $data);
    }

    public function store(Request $request)
    {

        $validate_rules = [
            'subject' => 'required',
            'description' => 'required',
            'ticket_file.*' => 'nullable|mimes:jpg,jpeg,bmp,png,doc,docx,csv,rtf,xlsx,xls,txt,pdf,sql,mp4',
            'priority_id' => 'required',
            'category_id' => 'required',
        ];

        $category = TicketCategory::find($request->category_id);

        if ($category && $category->slug == 'course') {
            $validate_rules['course_id'] = 'required';
        }

        $request->validate($validate_rules, validationMessage($validate_rules));


        try {
            $this->supportTicketService->create($request->except('_token'));


            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('student.support-ticket.index');
        } catch (Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function create()
    {
        $user = Auth::user();
        $data['ticket'] = $this->supportTicketService->new();
        $data['CategoryList'] = $this->supportTicketService->categoryList();
        $data['PriorityList'] = $this->supportTicketService->priorityList();
        $data['enroll_courses'] = $user->enrollCourse->where('support', true);
        return view(theme('pages.support-ticket-add-edit'), $data);

    }

    public function show($id)
    {
        $data['SupportTicket'] = $this->supportTicketService->supportTicketWithMsgAndFile($id);
        if(! $data['SupportTicket'] ){
            abort(404);
        }
        return view(theme('pages.support-ticket-details'), $data);
    }


    public function filter()
    {
        $status_id = request()->input('status_id');

        if (!$status_id) {
            return redirect()->route('support.index');
        }

        $data['userTickets'] = SupportTicket::with('attachFiles')
            ->where('user_id', Auth::id())
            ->Where('status_id', $status_id)
            ->get();
        $data['closedTickets'] = SupportTicket::where('user_id', Auth::id())
            ->where('status_id', 4)->get();
        $data['StatusList'] = TicketStatus::all();
        return view('supportticket::frontend.support.index', $data);
    }

    public function edit($id)
    {
        $user = Auth::user();
        $data['ticket'] = $this->supportTicketService->find($id);
        $data['CategoryList'] = $this->supportTicketService->categoryList();
        $data['PriorityList'] = $this->supportTicketService->priorityList();
        $data['enroll_courses'] = $user->enrollCourse->where('support', true);
        return view(theme('pages.support-ticket-add-edit'), $data);
    }

    public function update($id, Request $request)
    {
        $validate_rules = [
            'subject' => 'required',
            'description' => 'required',
            'ticket_file.*' => 'nullable|mimes:jpg,jpeg,bmp,png,doc,docx,csv,rtf,xlsx,xls,txt,pdf,sql,mp4',
            'priority_id' => 'required',
            'category_id' => 'required',
        ];

        $category = TicketCategory::find($request->category_id);

        if ($category->slug == 'course') {
            $validate_rules['course_id'] = 'required';
        }

        $request->validate($validate_rules, validationMessage($validate_rules));


        try {
            $this->supportTicketService->update($request->except('_token'), $id);


            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('student.support-ticket.index');
        } catch (Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function destroy(Request $request)
    {
        try {
            $ticket = $this->supportTicketService->ticketWithFile($request->id);
            if ($ticket && $ticket->user_id != Auth::id()) {
                abort(403);
            }
            $fileIds = [];
            foreach ($ticket->attachFiles as $key => $value) {
                if (file_exists($value->url)) {
                    unlink($value->url);
                }
                $fileIds[] = $value->id;
            }
            $this->supportTicketService->fileDelete($fileIds);
            $ticket->delete();

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('student.support-ticket.index');
        } catch (Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));

            return redirect()->back();
        }
    }
}
