@extends('backend.master')


@php
    $table_name = 'product_brands';
@endphp
@section('table')
    {{ $table_name }}
@endsection
@section('mainContent')
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-12">

                </div>
            </div>
            @if(isModuleActive('FrontendMultiLang'))
                @php
                    $LanguageList = getLanguageList();
                @endphp
            @endif
            <form action="{{isset($edit)?route("store.brand.update",$edit->id):route("store.brand.store")}}"
                  method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-lg-8">
                        <div class=" white-box  mb-20 student-details">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="main-title d-flex">
                                        <h3 class="mb-2 mr-30">{{ _trans('store.Brand Info') }}</h3>
                                    </div>
                                </div>
                                @if(isModuleActive('FrontendMultiLang'))
                                    <div class="col-lg-12">
                                        <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3"
                                            role="tablist">
                                            @foreach ($LanguageList as $key => $language)
                                                <li class="nav-item">
                                                    <a class="nav-link  @if (auth()->user()->language_code == $language->code) active @endif"
                                                       href="#element{{ $language->code }}" role="tab"
                                                       data-bs-toggle="tab">{{ $language->native }} </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                        <div class="tab-content">
                                            @foreach ($LanguageList as $key => $language)
                                                <div role="tabpanel"
                                                     class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif  "
                                                     id="element{{ $language->code }}">
                                                    <div class="col-lg-12">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label"
                                                                   for=""> {{_trans("common.Name")}} <span
                                                                    class="text-danger">*</span></label>
                                                            <input class="primary_input_field"
                                                                   name="name[{{$language->code}}]"
                                                                   placeholder="{{_trans("common.Name")}}" type="text"
                                                                   value="{{isset($edit)?$edit->getTranslation('name',$language->code):old('name.'.$language->code)}}">

                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label"
                                                                   for=""> {{_trans("common.Description")}} </label>
                                                            <textarea class="lms_summernote"
                                                                      name="description[{{$language->code}}]">{!!isset($edit)?$edit->getTranslation('description',$language->code):old('description.'.$language->code) !!}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @else
                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label" for=""> {{_trans("common.Name")}} <span
                                                    class="text-danger">*</span></label>
                                            <input class="primary_input_field" name="name"
                                                   placeholder="{{_trans("common.Name")}}" type="text"
                                                   value="{{isset($edit)?$edit->name:old('name')}}">

                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label"
                                                   for=""> {{_trans("common.Description")}} </label>
                                            <textarea class="lms_summernote "
                                                      name="description">{{isset($edit)?$edit->description:old('description')}}</textarea>
                                        </div>
                                    </div>
                                @endif

                                <div class="col-lg-12">
                                    <div class="primary_input mb-30">
                                        <label class="primary_input_label"
                                               for=""> {{_trans("store.Website Link")}}</label>
                                        <input class="primary_input_field" name="link"
                                               placeholder="{{_trans("product.website_link")}}" type="text"
                                               value="{{isset($edit)?$edit->link:old('link')}}">
                                        <span class="text-danger">{{$errors->first('link')}}</span>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="main-title d-flex">
                                        <h3 class="mb-2 mr-30">{{ _trans('common.SEO info') }}</h3>
                                    </div>
                                </div>
                                @if(isModuleActive('FrontendMultiLang'))
                                    <div class="col-lg-12">
                                        <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3"

                                        @foreach ($LanguageList as $key => $language)
                                            <li class="nav-item">
                                                <a class="nav-link anchore_color @if (auth()->user()->language_code == $language->code) active @endif"
                                                   href="#melement{{$language->code}}" role="tab" data-bs-toggle="tab"
                                                   aria-selected="@if (auth()->user()->language_code == $language->code) true @else false @endif">{{ $language->native }} </a>
                                            </li>
                                            @endforeach
                                            </ul>
                                            <div class="tab-content">
                                                @foreach ($LanguageList as $key => $language)
                                                    <div role="tabpanel"
                                                         class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif"
                                                         id="melement{{$language->code}}">
                                                        <div class="col-lg-12">
                                                            <div class="primary_input mb-15">
                                                                <label class="primary_input_label"
                                                                       for=""> {{_trans("common.Meta Title")}}</label>
                                                                <input class="primary_input_field"
                                                                       name="meta_title[{{$language->code}}]"
                                                                       placeholder="{{_trans("common.Meta Title")}}"
                                                                       type="text"
                                                                       value="{{isset($edit)?$edit->getTranslation('meta_title',$language->code):old('meta_title.'.$language->code)}}">
                                                                <span
                                                                    class="text-danger">{{$errors->first('meta_title')}}</span>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-12">
                                                            <div class="primary_input mb-15">
                                                                <label class="primary_input_label"
                                                                       for=""> {{_trans("common.Meta Description")}}</label>
                                                                <textarea
                                                                    class="primary_textarea height_112 meta_description"
                                                                    placeholder="{{ _trans('common.Meta Description') }}"
                                                                    name="meta_description[{{$language->code}}]"
                                                                    spellcheck="false">{!! isset($edit)?$edit->getTranslation('meta_description',$language->code):old('meta_description.'.$language->code) !!}</textarea>
                                                                <span
                                                                    class="text-danger">{{$errors->first('meta_description')}}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                    </div>
                                @else
                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label"
                                                   for=""> {{_trans("common.Meta Title")}}</label>
                                            <input class="primary_input_field" name="meta_title"
                                                   placeholder="{{_trans("common.Meta Title")}}" type="text"
                                                   value="{{isset($edit)?$edit->meta_title:old('meta_title')}}">
                                            <span class="text-danger">{{$errors->first('meta_title')}}</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label"
                                                   for=""> {{_trans("common.Meta Description")}}</label>
                                            <textarea class="primary_textarea height_112  meta_description"
                                                      placeholder="{{ _trans('common.Meta Description') }}"
                                                      name="meta_description"
                                                      spellcheck="false">{!! isset($edit)?$edit->meta_description:old('meta_description') !!}</textarea>
                                            <span class="text-danger">{{$errors->first('meta_description')}}</span>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="white-box">
                            <div class="row">

                                <div class="col-lg-7">
                                    <div class="main-title d-flex">
                                        <h3 class="mb-2 mr-30 text-nowrap">{{ _trans('common.logo') }}
                                        </h3>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="logo_div">

                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="  mb-25">
                                        <x-upload-file
                                            name="logo"
                                            type="image"
                                            media_id="{{isset($edit)?$edit->logo_media?->media_id:''}}"

                                            note="{{__('student.Recommended size')}} (150x150)"
                                        />


                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="main-title d-flex">
                                        <h3 class="mb-2 mr-30">{{ _trans('common.is_featured') }}</h3>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="primary_input mb-25">
                                        <label class="switch_toggle">
                                            <input type="checkbox" name="featured"
                                                {{isset($edit) && $edit->featured==1? 'checked':'' }} >
                                            <div class="slider round"></div>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="d-flex justify-content-center pt_20">
                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                id="save_button_parent">
                                            <i class=" fa fa-check "></i>

                                            {{__("common.save")}}

                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
@endsection
@push('scripts')
    <script type="text/javascript">
        (function ($) {
            "use strict";
            $(document).ready(function () {
                $(document).on('change', '#logo', function (event) {
                    getFileName($(this).val(), '#logo_file');
                    imageChangeWithFile($(this)[0], '#logoImg');
                });
            });
        })(jQuery);
    </script>



    <script src="{{ asset('/') }}/Modules/Store/Resources/assets/js/category.js"></script>
@endpush
