<?php

namespace Modules\Noticeboard\Repositories\Eloquents;

use App\Repositories\Eloquents\BaseRepository;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Modules\Noticeboard\Entities\Noticeboard;
use Modules\Noticeboard\Entities\NoticeboardAssign;
use Modules\Noticeboard\Repositories\Interfaces\CourseNoticeboardRepositoryInterface;

class CourseNoticeboardRepository extends BaseRepository implements CourseNoticeboardRepositoryInterface
{
    protected $model, $noticeboardAssign;

    public function __construct(Noticeboard $model, NoticeboardAssign $noticeboardAssign)
    {
        $this->model = $model;
        $this->noticeboardAssign = $noticeboardAssign;
    }

    public function allCourse(array $columns = ['*'], array $relations = []): Collection
    {
        $query = $this->model->where('group', 2)->with($relations);

        if (isModuleActive('Organization') && Auth::user()->isOrganization()) {
            $query->whereHas('user', function ($q) {
                $q->where('organization_id', Auth::id());
                $q->orWhere('user_id', Auth::id());
            });
        }

        return $query->latest()->get($columns);
    }

    public function createCourseNotice(array $payload): ?Model
    {
        $payload['user_id'] = Auth::id();
        $model = $this->model->create($payload);
        $this->courseAssign($model->id, $payload['course_id']);

        if ($model) {
            $this->successMsg();
        }
        return $model->fresh();
    }

    public function updateCourseNotice(array $payload): ?bool
    {
        $model = $this->model->where('id', $payload['id'])->update(Arr::except($payload, ['course_id']));

        $this->courseDelete($payload['id']);
        $this->courseAssign($payload['id'], $payload['course_id']);

        if ($model) {
            $this->successMsg();
        }
        return $model;
    }

    public function deleteCourseNotice(array $payload): void
    {
        $model = $this->model->where('id', $payload['id'])->first();
        $model->delete();
        $this->courseDelete($payload['id']);
        $this->successMsg();
    }


    private function courseAssign(int $noticeboard, array $course_ids)
    {
        foreach ($course_ids as $course_id) {
            $this->noticeboardAssign->create([
                'course_id' => $course_id,
                'noticeboard_id' => $noticeboard
            ]);
        }
    }

    private function courseDelete(int $noticeboard)
    {
        $this->noticeboardAssign->where('noticeboard_id', $noticeboard)->delete();
    }
}
