<?php

namespace Modules\Noticeboard\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\Noticeboard\Repositories\Eloquents\CourseNoticeboardRepository;
use Modules\Noticeboard\Repositories\Eloquents\NoticeboardRepository;
use Modules\Noticeboard\Repositories\Eloquents\NoticeboardTypeRepository;
use Modules\Noticeboard\Repositories\Interfaces\CourseNoticeboardRepositoryInterface;
use Modules\Noticeboard\Repositories\Interfaces\NoticeboardRepositoryInterface;
use Modules\Noticeboard\Repositories\Interfaces\NoticeboardTypeRepositoryInterface;

class RepositoryServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->app->bind(NoticeboardTypeRepositoryInterface::class, NoticeboardTypeRepository::class);
        $this->app->bind(CourseNoticeboardRepositoryInterface::class, CourseNoticeboardRepository::class);
        $this->app->bind(NoticeboardRepositoryInterface::class, NoticeboardRepository::class);

    }

    public function boot()
    {
        //
    }
}
