<?php

namespace Modules\Noticeboard\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Course;
use Modules\RolePermission\Entities\Role;

class NoticeboardAssign extends Model
{
    protected $guarded = ['id'];

    public function notice()
    {
        return $this->belongsTo(Noticeboard::class, 'noticeboard_id')->withDefault();
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id')->withDefault();
    }

    public function role()
    {
        return $this->belongsTo(Role::class, 'role_id')->withDefault();
    }
}
