@extends('appointment::layouts.master')
@php
    $table_name = 'request_lists';
@endphp
@section('table')
    {{ $table_name }}
@endsection
@section('mainContent')
    <input type="hidden" id="row_count" value="1">
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row justify-content-center">

                    <div class="col-lg-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0" id="page_title">{{ __('appointment.Post Request List') }}</h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Student Name') }}</th>
                                            <th scope="col">{{ __('appointment.Max Price') }}</th>
                                            <th scope="col">{{ __('appointment.Min Price') }}</th>
                                            <th scope="col">{{ __('appointment.Teaching Category') }}</th>
                                            <th scope="col">{{ __('appointment.Headline') }}</th>
                                            <th scope="col">{{ __('common.Name') }}</th>
                                            <th scope="col">{{ __('common.Email') }}</th>
                                            <th scope="col">{{ __('common.Date') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($postRequests as $key => $item)
                                            <tr>
                                                <th class="m-2">{{ $loop->iteration }}</th>
                                                <td>{{ $item->userInfo->name }}</td>
                                                <td>{{ $item->min_price }}</td>
                                                <td>{{ $item->max_price }}</td>
                                                <td>{{ $item->category->name }}</td>
                                                <td>{{ $item->headline }}</td>
                                                <td>{{ $item->name }}</td>
                                                <td>{{ $item->email }}</td>
                                                <td>{{ showDate($item->created_at) }}</td>
                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{ @$item->id }}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{ @$item->id }}">
                                                            <a onclick="confirm_modal('{{ route('appointment.post.destroy', @$item->id) }}');"
                                                               class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>
                                                            <a href="{{ route('appointment.post.share-instructor',[$item->id]) }}"
                                                               class="dropdown-item" target="_blank">
                                                                {{ __('appointment.Share Instructor') }}
                                                            </a>

                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @include('backend.partials.delete_modal')
@endsection

@push('scripts')
    <script type="application/javascript">

        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5, 6, 7, 8]);

            $('#lms_table').DataTable(dataTableOptions);


        })(jQuery);
    </script>
@endpush
